/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes;

import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.actions.AddResourceAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.DeleteAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.DeleteServerAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ModifyServerAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.NewServerAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.PropertiesAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RefreshAction;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FolderChildren;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ServerChildren;
import com.jaspersoft.ireport.jasperserver.ui.nodes.dnd.FolderPasteType;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class FolderNode
extends IRIndexedNode
implements ResourceNode {
    private boolean root = false;
    private RepositoryFolder folder = null;
    private boolean loading = false;
    protected static final ImageIcon loadingIcon = new ImageIcon(FolderNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/waiting.png"));
    protected static final ImageIcon serverIcon = new ImageIcon(FolderNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/server.png"));
    protected static final ImageIcon folderIcon = new ImageIcon(FolderNode.class.getResource("/com/jaspersoft/ireport/jasperserver/res/folder.png"));

    public boolean hasCustomizer() {
        return false;
    }

    public FolderNode(RepositoryFolder folder, Lookup doLkp) {
        this(new FolderChildren(folder, doLkp), folder, doLkp, false);
    }

    public FolderNode(RepositoryFolder folder, Lookup doLkp, boolean root) {
        this(new FolderChildren(folder, doLkp), folder, doLkp, root);
    }

    public FolderNode(FolderChildren pc, RepositoryFolder folder, Lookup doLkp, boolean root) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{folder, folder.getServer()})}));
        this.root = root;
        this.folder = folder;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public RepositoryFolder getFolder() {
        return this.folder;
    }

    public void setFolder(RepositoryFolder folder) {
        this.folder = folder;
    }

    public String getDisplayName() {
        return this.getFolder().getDescriptor().getLabel() + (this.isLoading() ? " (Loading....)" : "");
    }

    public Image getIcon(int arg0) {
        if (this.isLoading()) {
            return loadingIcon.getImage();
        }
        if (this.isRoot()) {
            return serverIcon.getImage();
        }
        return folderIcon.getImage();
    }

    public Image getOpenedIcon(int arg0) {
        if (this.isLoading()) {
            return loadingIcon.getImage();
        }
        if (this.isRoot()) {
            return serverIcon.getImage();
        }
        return folderIcon.getImage();
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        this.fireIconChange();
    }

    public Action[] getActions(boolean arg0) {
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(AddResourceAction.class));
        list.add(null);
        if (this.isRoot()) {
            list.add(SystemAction.get(NewServerAction.class));
            list.add(SystemAction.get(ModifyServerAction.class));
            list.add(SystemAction.get(DeleteServerAction.class));
            list.add(SystemAction.get(AddResourceAction.class));
            list.add(SystemAction.get(PasteAction.class));
        } else {
            list.add(SystemAction.get(CopyAction.class));
            list.add(SystemAction.get(CutAction.class));
            list.add(SystemAction.get(PasteAction.class));
            list.add(SystemAction.get(DeleteAction.class));
        }
        list.add(null);
        list.add(SystemAction.get(RefreshAction.class));
        list.add(SystemAction.get(PropertiesAction.class));
        return list.toArray(new Action[list.size()]);
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.getFolder().getDescriptor();
    }

    public RepositoryFolder getRepositoryObject() {
        return this.getFolder();
    }

    public void refreshChildrens(boolean reload) {
        Children children = this.getChildren();
        if (children instanceof FolderChildren) {
            ((FolderChildren)children).recalculateKeys(reload);
        } else if (children instanceof ServerChildren) {
            ((ServerChildren)children).recalculateKeys();
        }
    }

    public void updateDisplayName() {
        this.fireDisplayNameChange(null, null);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        return FolderPasteType.createFolderPasteType(DnDUtilities.getTransferAction((Transferable)t), this, dropNode);
    }

    public boolean canCopy() {
        return !this.isRoot();
    }

    public boolean canCut() {
        return !this.isRoot();
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }
}

