/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Category;
import mondrian.olap.Cube;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public abstract class FunDefBase
extends FunUtil
implements FunDef {
    protected final int flags;
    private final String name;
    private final String description;
    protected final int returnCategory;
    protected final int[] parameterCategories;

    FunDefBase(String name, String signature, String description, Syntax syntax, int returnCategory, int[] parameterCategories) {
        this.name = name;
        Util.discard((Object)signature);
        this.description = description;
        this.flags = syntax.ordinal();
        this.returnCategory = returnCategory;
        this.parameterCategories = parameterCategories;
    }

    protected FunDefBase(String name, String signature, String description, String flags) {
        this(name, signature, description, FunDefBase.decodeSyntacticType(flags), FunDefBase.decodeReturnCategory(flags), FunDefBase.decodeParameterCategories(flags));
    }

    FunDefBase(Resolver resolver, int returnType, int[] parameterTypes) {
        this(resolver.getName(), null, null, resolver.getSyntax(), returnType, parameterTypes);
    }

    FunDefBase(FunDef funDef) {
        this(funDef.getName(), funDef.getSignature(), funDef.getDescription(), funDef.getSyntax(), funDef.getReturnCategory(), funDef.getParameterCategories());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Syntax getSyntax() {
        return ((Syntax[])Syntax.class.getEnumConstants())[this.flags];
    }

    public int getReturnCategory() {
        return this.returnCategory;
    }

    public int[] getParameterCategories() {
        return this.parameterCategories;
    }

    public Exp createCall(Validator validator, Exp[] args) {
        int[] categories = this.getParameterCategories();
        Util.assertTrue(categories.length == args.length);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.validateArg(validator, args, i, categories[i]);
        }
        Type type = this.getResultType(validator, args);
        if (type == null) {
            throw Util.newInternal("could not derive type");
        }
        return new ResolvedFunCall(this, args, type);
    }

    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        return args[i];
    }

    static Type guessResultType(Exp[] args, int category, String name) {
        switch (category) {
            case 5: {
                return new BooleanType();
            }
            case 7: {
                return new NumericType();
            }
            case 15: {
                return new DecimalType(Integer.MAX_VALUE, 0);
            }
            case 9: {
                return new StringType();
            }
            case 11: {
                return new SymbolType();
            }
            case 13: {
                return new ScalarType();
            }
            case 12: {
                if (args.length <= 0 || !(args[0] instanceof Cube)) break;
                return new CubeType((Cube)((Object)args[0]));
            }
            case 2: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                return DimensionType.forType(type);
            }
            case 3: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                return HierarchyType.forType(type);
            }
            case 4: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                return LevelType.forType(type);
            }
            case 6: {
                Type type;
                MemberType memberType;
                if (args.length > 0 && (memberType = TypeUtil.toMemberType(type = args[0].getType())) != null) {
                    return memberType;
                }
                return MemberType.Unknown;
            }
            case 10: {
                Type type;
                Type memberType;
                if (args.length <= 0 || (memberType = TypeUtil.toMemberOrTupleType(type = args[0].getType())) == null) break;
                return memberType;
            }
            case 8: {
                Type type;
                Type memberType;
                if (args.length <= 0 || (memberType = TypeUtil.toMemberOrTupleType(type = args[0].getType())) == null) break;
                return new SetType(memberType);
            }
            default: {
                throw Category.instance.badValue(category);
            }
        }
        throw Util.newInternal("Cannot deduce type of call to function '" + name + "'");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        return FunDefBase.guessResultType(args, this.getReturnCategory(), this.name);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        throw Util.newInternal("function '" + this.getSignature() + "' has not been implemented");
    }

    public String getSignature() {
        return this.getSyntax().getSignature(this.getName(), this.getReturnCategory(), this.getParameterCategories());
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        this.getSyntax().unparse(this.getName(), args, pw);
    }
}

