/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.util.Collection;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import javax.olap.query.edgefilters.CurrentEdgeMember;
import javax.olap.query.enumerations.EdgeFilterType;
import javax.olap.query.querycoremodel.CubeView;
import javax.olap.query.querycoremodel.DimensionView;
import javax.olap.query.querycoremodel.EdgeFilter;
import javax.olap.query.querycoremodel.EdgeView;
import javax.olap.query.querycoremodel.Segment;
import javax.olap.query.querycoremodel.Tuple;
import mondrian.jolap.MondrianCubeView;
import mondrian.jolap.MondrianEdgeFilter;
import mondrian.jolap.MondrianSegment;
import mondrian.jolap.OrderedRelationshipList;
import mondrian.jolap.OrdinateSupport;
import mondrian.jolap.Relationship;
import mondrian.jolap.RelationshipList;

class MondrianEdgeView
extends OrdinateSupport
implements EdgeView {
    private RelationshipList edgeCursor = new RelationshipList(Meta.edgeCursor);
    private OrderedRelationshipList dimensionView = new OrderedRelationshipList(Meta.dimensionView);
    private OrderedRelationshipList segment = new OrderedRelationshipList(Meta.segment);
    private OrderedRelationshipList edgeFilter = new OrderedRelationshipList(Meta.edgeFilter);
    private MondrianCubeView ordinateOwner;
    private MondrianCubeView pageOwner;

    public MondrianEdgeView(MondrianCubeView owner, boolean isPage) {
        if (isPage) {
            this.pageOwner = owner;
        } else {
            this.ordinateOwner = owner;
        }
    }

    public CubeView getPageOwner() throws OLAPException {
        return this.pageOwner;
    }

    public void setPageOwner(CubeView value) throws OLAPException {
        this.pageOwner = (MondrianCubeView)value;
    }

    public CubeView getOrdinateOwner() throws OLAPException {
        return this.ordinateOwner;
    }

    public void setOrdinateOwner(CubeView value) throws OLAPException {
        this.ordinateOwner = (MondrianCubeView)value;
    }

    public List getDimensionView() throws OLAPException {
        return this.dimensionView;
    }

    public Collection getEdgeCursor() throws OLAPException {
        return this.edgeCursor;
    }

    public List getSegment() throws OLAPException {
        return this.segment;
    }

    public List getEdgeFilter() throws OLAPException {
        return this.edgeFilter;
    }

    public Collection getTuple() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public EdgeCursor createCursor() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public Segment createSegment() throws OLAPException {
        return (Segment)this.segment.addNew(new MondrianSegment());
    }

    public Segment createSegmentBefore(Segment member) throws OLAPException {
        return (Segment)this.segment.addBefore(member, new MondrianSegment());
    }

    public Segment createSegmentAfter(Segment member) throws OLAPException {
        return (Segment)this.segment.addAfter(member, new MondrianSegment());
    }

    public EdgeFilter createEdgeFilter(EdgeFilterType type) throws OLAPException {
        return (EdgeFilter)this.edgeFilter.addNew(MondrianEdgeFilter.create(type));
    }

    public EdgeFilter createEdgeFilterBefore(EdgeFilterType type, EdgeFilter member) throws OLAPException {
        return (EdgeFilter)this.edgeFilter.addBefore(member, MondrianEdgeFilter.create(type));
    }

    public EdgeFilter createEdgeFilterAfter(EdgeFilterType type, EdgeFilter member) throws OLAPException {
        return (EdgeFilter)this.edgeFilter.addAfter(member, MondrianEdgeFilter.create(type));
    }

    public Tuple createTuple() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public CurrentEdgeMember createCurrentEdgeMember() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    static abstract class Meta {
        static final Relationship dimensionView = new Relationship(MondrianEdgeView.class, "dimensionView", DimensionView.class);
        static final Relationship edgeCursor = new Relationship(MondrianEdgeView.class, "edgeCursor", EdgeCursor.class);
        static final Relationship segment = new Relationship(MondrianEdgeView.class, "segment", Segment.class);
        static final Relationship edgeFilter = new Relationship(MondrianEdgeView.class, "edgeFilter", EdgeFilter.class);

        Meta() {
        }
    }
}

