/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLanguageHierarchy
extends LanguageHierarchy<STokenId> {
    private String mimeType;
    private List<STokenId> tokenIDs;
    private Map<Integer, STokenId> tokenIDToType;

    public SLanguageHierarchy(String string) {
        this.mimeType = string;
    }

    protected Collection<STokenId> createTokenIds() {
        if (this.tokenIDs == null) {
            Language language = this.getLanguage();
            List<TokenType> list = language.getParser().getTokenTypes();
            this.tokenIDToType = new HashMap<Integer, STokenId>();
            this.tokenIDs = new ArrayList<STokenId>();
            HashSet<String> hashSet = new HashSet<String>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                TokenType tokenType = list.get(i);
                String string = tokenType.getType();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                STokenId sTokenId = new STokenId(string, language.getTokenID(string), string);
                this.tokenIDs.add(sTokenId);
                this.tokenIDToType.put(sTokenId.ordinal(), sTokenId);
            }
        }
        return this.tokenIDs;
    }

    protected Lexer<STokenId> createLexer(LexerRestartInfo<STokenId> lexerRestartInfo) {
        if (this.tokenIDs == null) {
            this.createTokenIds();
        }
        return new SLexer(this.getLanguage(), this.tokenIDToType, lexerRestartInfo);
    }

    protected String mimeType() {
        return this.mimeType;
    }

    private Language getLanguage() {
        try {
            return LanguagesManager.getDefault().getLanguage(this.mimeType);
        }
        catch (ParseException parseException) {
            return Language.create(this.mimeType);
        }
    }
}

