/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.NBSLanguage;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.Selector;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.Pattern;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBSLanguageReader {
    private String source;
    private String sourceName;
    private String mimeType;
    private GRNode grammarTree;
    private List<TokenType> tokenTypes;
    private Map<String, Integer> tokenTypeToID = new HashMap<String, Integer>();
    private List<Feature> features;
    private List<Rule> grammarRules;

    public static NBSLanguageReader create(FileObject fileObject, String string) throws IOException {
        return NBSLanguageReader.create(fileObject.getInputStream(), fileObject.getPath(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBSLanguageReader create(InputStream inputStream, String string, String string2) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuilder.append(string3).append('\n');
                string3 = bufferedReader.readLine();
            }
            NBSLanguageReader nBSLanguageReader = NBSLanguageReader.create(stringBuilder.toString(), string, string2);
            return nBSLanguageReader;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static NBSLanguageReader create(String string, String string2, String string3) {
        return new NBSLanguageReader(string, string2, string3);
    }

    private NBSLanguageReader(String string, String string2, String string3) {
        this.source = string;
        this.sourceName = string2;
        this.mimeType = string3;
    }

    public List<TokenType> getTokenTypes() throws ParseException {
        if (this.features == null) {
            this.readNBS();
        }
        if (this.tokenTypes == null) {
            return Collections.emptyList();
        }
        return this.tokenTypes;
    }

    public List<Feature> getFeatures() throws ParseException {
        if (this.features == null) {
            this.readNBS();
        }
        return this.features;
    }

    public List<Rule> getRules(Language language) {
        if (this.grammarRules == null) {
            this.grammarRules = this.createRules(this.grammarTree, language);
        }
        return this.grammarRules;
    }

    private void readNBS() throws ParseException {
        this.features = new ArrayList<Feature>();
        StringInput stringInput = new StringInput(this.source);
        ASTNode aSTNode = null;
        TokenInput tokenInput = null;
        try {
            Language language = NBSLanguage.getNBSLanguage();
            tokenInput = TokenInputUtils.create(language, language.getParser(), stringInput);
            aSTNode = language.getAnalyser().read(tokenInput, false, new boolean[]{false});
            if (aSTNode == null) {
                System.out.println("Can not parse " + this.sourceName);
            } else if (aSTNode.getChildren().isEmpty()) {
                System.out.println("Can not parse " + this.sourceName + " " + aSTNode.getNT());
            }
        }
        catch (ParseException parseException) {
            Point point = Utils.findPosition(this.source, tokenInput.getOffset());
            throw new ParseException(this.sourceName + " " + point.x + "," + point.y + ": " + parseException.getMessage());
        }
        this.readBody(aSTNode);
    }

    private void readBody(ASTNode aSTNode) throws ParseException {
        this.grammarTree = new GRNode();
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTItem aSTItem : aSTNode.getChildren()) {
            if (aSTItem instanceof ASTToken) continue;
            ASTNode aSTNode2 = (ASTNode)aSTItem;
            if (aSTNode2.getNT().equals("token")) {
                this.readToken(aSTNode2, null);
                continue;
            }
            if (aSTNode2.getNT().equals("tokenState")) {
                this.readTokenState(aSTNode2);
                continue;
            }
            if (aSTNode2.getNT().equals("grammarRule")) {
                this.readGrammarRule(aSTNode2, this.grammarTree);
                continue;
            }
            if (aSTNode2.getNT().equals("command")) {
                this.readCommand(aSTNode2, hashSet);
                continue;
            }
            throw new ParseException("Unknown grammar rule (" + aSTNode2.getNT() + ").");
        }
    }

    private void readToken(ASTNode aSTNode, String string) throws ParseException {
        String string2 = null;
        String string3 = null;
        Pattern pattern = null;
        Feature feature = null;
        String string4 = aSTNode.getTokenType("identifier").getIdentifier();
        ASTNode aSTNode2 = aSTNode.getNode("token2.properties");
        if (aSTNode2 != null) {
            feature = this.readProperties(null, null, aSTNode2);
            string2 = (String)feature.getValue("start_state");
            string3 = (String)feature.getValue("end_state");
            pattern = feature.getPattern("pattern");
            if (pattern == null && feature.getType("call") == Feature.Type.METHOD_CALL) {
                pattern = Pattern.create(".");
            }
        } else {
            ASTNode aSTNode3 = aSTNode.getNode("token2.regularExpression");
            string3 = aSTNode.getTokenTypeIdentifier("token2.token3.state.identifier");
            pattern = this.readPattern(aSTNode3, aSTNode3.getOffset());
        }
        if (string2 != null && string != null) {
            throw new ParseException("Start state should not be specified inside token group block!");
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string3 == null) {
            string3 = string;
        }
        this.addToken(string2, pattern, string4, string3, feature);
    }

    private void addToken(String string, Pattern pattern, String string2, String string3, Feature feature) {
        if (this.tokenTypes == null) {
            this.tokenTypes = new ArrayList<TokenType>();
            this.addToken(null, null, "error", null, null);
            this.addToken(null, null, "PE", null, null);
            this.addToken(null, null, "GAP", null, null);
        }
        int n = this.tokenTypeToID.size();
        if (this.tokenTypeToID.containsKey(string2)) {
            n = this.tokenTypeToID.get(string2);
        } else {
            this.tokenTypeToID.put(string2, n);
        }
        this.tokenTypes.add(new TokenType(string, pattern, string2, n, string3, this.tokenTypes.size(), feature));
    }

    private void readGrammarRule(ASTNode aSTNode, GRNode gRNode) {
        String string = aSTNode.getTokenTypeIdentifier("identifier");
        ASTNode aSTNode2 = aSTNode.getNode("grRightSide");
        if (aSTNode2.getChildren().size() == 0) {
            gRNode.get(string).setFinal();
        } else {
            NBSLanguageReader.resolveGrammarRule(string, aSTNode2, new Franta(), gRNode, null);
        }
    }

    private static GRNode resolveGrammarRule(String string, ASTNode aSTNode, Franta franta, GRNode gRNode, GRNode gRNode2) {
        for (ASTItem aSTItem : aSTNode.getChildren()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            Object object5;
            int n;
            if (aSTItem instanceof ASTToken) continue;
            ASTNode aSTNode2 = (ASTNode)aSTItem;
            if (aSTNode2.getNT().equals("grRightSide1")) {
                NBSLanguageReader.resolveGrammarRule(string, aSTNode2, franta, gRNode, gRNode2);
                continue;
            }
            if (aSTNode2.getNT().equals("grChoice")) {
                gRNode2 = NBSLanguageReader.resolveGrammarRule(string, aSTNode2, franta, gRNode, gRNode.get(string));
                gRNode2.setFinal();
                continue;
            }
            if (!aSTNode2.getNT().equals("grPart")) continue;
            List<ASTItem> list = aSTNode2.getChildren();
            for (n = 0; n < list.size() && NBSLanguageReader.skip(list.get(n)); ++n) {
            }
            if (list.get(n) instanceof ASTNode) {
                object5 = NBSLanguageReader.readToken((ASTNode)list.get(n));
                ++n;
                while (n < list.size() && NBSLanguageReader.skip(list.get(n))) {
                    ++n;
                }
                if (n < list.size()) {
                    string2 = ((ASTNode)list.get(n)).getTokenTypeIdentifier("operator");
                    if (string2 != null) {
                        object4 = franta.next(string);
                        gRNode2 = gRNode2.get((String)object4);
                        if ("*".equals(string2)) {
                            object3 = gRNode.get((String)object4);
                            ((GRNode)object3).setFinal();
                            object3 = ((GRNode)object3).get((String)object5);
                            object3 = ((GRNode)object3).get((String)object4);
                            ((GRNode)object3).setFinal();
                            continue;
                        }
                        if (!"+".equals(string2)) continue;
                        object3 = gRNode.get((String)object4);
                        object2 = franta.next(string);
                        object3 = ((GRNode)object3).get((String)object5);
                        object3 = ((GRNode)object3).get((String)object2);
                        ((GRNode)object3).setFinal();
                        object = gRNode.get((String)object2);
                        ((GRNode)object).setFinal();
                        object = ((GRNode)object).get((String)object5);
                        object = ((GRNode)object).get((String)object2);
                        ((GRNode)object).setFinal();
                        continue;
                    }
                    gRNode2 = gRNode2.get((String)object5);
                    continue;
                }
                gRNode2 = gRNode2.get((String)object5);
                continue;
            }
            object5 = (ASTToken)list.get(n);
            if (((ASTToken)object5).getIdentifier().equals("(")) {
                Object object6;
                string2 = aSTNode2.getTokenTypeIdentifier("grOperator.operator");
                object4 = franta.next(string);
                gRNode2 = gRNode2.get((String)object4);
                object3 = aSTNode2.getNode("grRightSide");
                if ("*".equals(string2)) {
                    object2 = gRNode.get((String)object4);
                    object = franta.next(string);
                    ((GRNode)object2).setFinal();
                    object2 = ((GRNode)object2).get((String)object);
                    object2 = ((GRNode)object2).get((String)object4);
                    ((GRNode)object2).setFinal();
                    object6 = gRNode.get((String)object);
                    NBSLanguageReader.resolveGrammarRule((String)object, (ASTNode)object3, franta, gRNode, (GRNode)object6);
                    continue;
                }
                if ("+".equals(string2)) {
                    object2 = gRNode.get((String)object4);
                    object = franta.next(string);
                    object6 = franta.next(string);
                    object2 = ((GRNode)object2).get((String)object);
                    object2 = ((GRNode)object2).get((String)object6);
                    ((GRNode)object2).setFinal();
                    GRNode gRNode3 = gRNode.get((String)object6);
                    gRNode3.setFinal();
                    gRNode3 = gRNode3.get((String)object);
                    gRNode3 = gRNode3.get((String)object6);
                    gRNode3.setFinal();
                    GRNode gRNode4 = gRNode.get((String)object);
                    NBSLanguageReader.resolveGrammarRule((String)object, (ASTNode)object3, franta, gRNode, gRNode4);
                    continue;
                }
                object2 = gRNode.get((String)object4);
                NBSLanguageReader.resolveGrammarRule((String)object4, (ASTNode)object3, franta, gRNode, (GRNode)object2);
                continue;
            }
            if (((ASTToken)object5).getIdentifier().equals("[")) {
                string2 = franta.next(string);
                gRNode2 = gRNode2.get(string2);
                object4 = aSTNode2.getNode("grRightSide");
                NBSLanguageReader.resolveGrammarRule(string2, (ASTNode)object4, franta, gRNode, null);
                gRNode.get(string2).setFinal();
                continue;
            }
            ++n;
            while (n < list.size() && NBSLanguageReader.skip(list.get(n))) {
                ++n;
            }
            if (n < list.size()) {
                if (list.get(n) instanceof ASTToken) {
                    System.out.println(list.get(n));
                }
                if ((string2 = ((ASTNode)list.get(n)).getTokenTypeIdentifier("operator")) != null) {
                    object4 = franta.next(string);
                    gRNode2 = gRNode2.get((String)object4);
                    if ("*".equals(string2)) {
                        object3 = gRNode.get((String)object4);
                        ((GRNode)object3).setFinal();
                        object3 = ((GRNode)object3).get(((ASTToken)object5).getIdentifier());
                        object3 = ((GRNode)object3).get((String)object4);
                        ((GRNode)object3).setFinal();
                        continue;
                    }
                    if (!"+".equals(string2)) continue;
                    object3 = gRNode.get((String)object4);
                    object2 = franta.next(string);
                    object3 = ((GRNode)object3).get(((ASTToken)object5).getIdentifier());
                    object3 = ((GRNode)object3).get((String)object2);
                    ((GRNode)object3).setFinal();
                    object = gRNode.get((String)object2);
                    ((GRNode)object).setFinal();
                    object = ((GRNode)object).get(((ASTToken)object5).getIdentifier());
                    object = ((GRNode)object).get((String)object2);
                    ((GRNode)object).setFinal();
                    continue;
                }
                gRNode2 = gRNode2.get(((ASTToken)object5).getIdentifier());
                continue;
            }
            gRNode2 = gRNode2.get(((ASTToken)object5).getIdentifier());
        }
        return gRNode2;
    }

    private static boolean skip(ASTItem aSTItem) {
        if (aSTItem instanceof ASTNode) {
            return false;
        }
        int n = ((ASTToken)aSTItem).getTypeID();
        if (NBSLanguage.WHITESPACE_ID == n) {
            return true;
        }
        return NBSLanguage.COMMENT_ID == n;
    }

    private static String readToken(ASTNode aSTNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = aSTNode.getTokenTypeIdentifier("identifier");
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append('#');
        String string2 = aSTNode.getTokenTypeIdentifier("tokenDef1.string");
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private List<Rule> createRules(GRNode gRNode, Language language) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (String string : gRNode.names()) {
            GRNode gRNode2 = gRNode.get(string);
            this.resolveNT(string, 0, gRNode2, new ArrayList(), arrayList, language);
        }
        return arrayList;
    }

    private void resolveNT(String string, int n, GRNode gRNode, List arrayList, List<Rule> list, Language language) {
        if (string.equals("S$3")) {
            System.out.println("");
        }
        while (true) {
            Iterator<String> iterator = gRNode.names();
            if (!gRNode.isFinal() && iterator.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (gRNode.isFinal()) {
                NBSLanguageReader.addRule(string, n, new ArrayList(arrayList), list);
            }
            if (iterator.isEmpty()) {
                return;
            }
            if (iterator.size() > 1) break;
            String string2 = iterator.iterator().next();
            this.addItem(arrayList, string2, language);
            gRNode = gRNode.get(string2);
        }
        if (!arrayList.isEmpty()) {
            arrayList.add(string + "#" + (n + 1));
            NBSLanguageReader.addRule(string, n, arrayList, list);
            ++n;
            for (String string2 : gRNode.names()) {
                arrayList = new ArrayList();
                this.addItem(arrayList, string2, language);
                this.resolveNT(string, n, gRNode.get(string2), arrayList, list, language);
            }
        } else {
            for (String string2 : gRNode.names()) {
                arrayList = new ArrayList<String>();
                this.addItem(arrayList, string2, language);
                this.resolveNT(string, n, gRNode.get(string2), arrayList, list, language);
            }
        }
    }

    private void addItem(List list, String string, Language language) {
        String string2;
        if (string.startsWith("\"")) {
            list.add(ASTToken.create(language, -1, string.substring(1, string.length() - 1), 0));
            return;
        }
        int n = string.indexOf(35);
        if (n < 0) {
            list.add(string);
            return;
        }
        String string3 = string.substring(0, n);
        int n2 = string3.length() > 0 ? language.getTokenID(string3) : -1;
        if ((string2 = string.substring(++n)).length() > 0) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        list.add(ASTToken.create(language, n2, string2.length() > 0 ? string2 : null, 0));
    }

    private static void addRule(String string, int n, List list, List<Rule> list2) {
        if (n > 0) {
            string = string + "#" + n;
        }
        list2.add(Rule.create(string, list));
    }

    private void readTokenState(ASTNode aSTNode) throws ParseException {
        String string = aSTNode.getTokenTypeIdentifier("state.identifier");
        ASTNode aSTNode2 = aSTNode.getNode("tokenState1.token");
        if (aSTNode2 != null) {
            this.readToken(aSTNode2, string);
        } else {
            this.readTokenGroup(aSTNode.getNode("tokenState1.tokenGroup"), string);
        }
    }

    private void readTokenGroup(ASTNode aSTNode, String string) throws ParseException {
        for (ASTItem aSTItem : aSTNode.getNode("tokensInGroup").getChildren()) {
            if (aSTItem instanceof ASTToken) continue;
            ASTNode aSTNode2 = (ASTNode)aSTItem;
            this.readToken(aSTNode2, string);
        }
    }

    private void readCommand(ASTNode aSTNode, Set<String> set) throws ParseException {
        String string = aSTNode.getTokenTypeIdentifier("keyword");
        ASTNode aSTNode2 = aSTNode.getNode("command0");
        ASTNode aSTNode3 = aSTNode2.getNode("selector");
        if (aSTNode3 != null) {
            for (Selector selector : NBSLanguageReader.readSelector(aSTNode3)) {
                ASTNode aSTNode4 = aSTNode2.getNode("command1");
                ASTNode aSTNode5 = aSTNode4.getNode("value");
                if (aSTNode5 != null) {
                    this.features.add(this.readValue(string, selector, aSTNode5));
                    continue;
                }
                this.features.add(Feature.create(string, selector));
            }
        } else {
            ASTNode aSTNode6 = aSTNode2.getNode("value");
            this.features.add(this.readValue(string, null, aSTNode6));
        }
    }

    private Feature readValue(String string, Selector selector, ASTNode aSTNode) throws ParseException {
        ASTNode aSTNode2 = aSTNode.getNode("properties");
        if (aSTNode2 != null) {
            return this.readProperties(string, selector, aSTNode2);
        }
        ASTNode aSTNode3 = aSTNode.getNode("class");
        if (aSTNode3 != null) {
            return Feature.createMethodCallFeature(string, selector, NBSLanguageReader.readClass(aSTNode3));
        }
        ASTNode aSTNode4 = aSTNode.getNode("regularExpression");
        if (aSTNode4 != null) {
            Pattern pattern = this.readPattern(aSTNode4, aSTNode4.getOffset());
            return Feature.createExpressionFeature(string, selector, pattern);
        }
        String string2 = aSTNode.getTokenTypeIdentifier("string");
        string2 = string2.substring(1, string2.length() - 1);
        return Feature.createExpressionFeature(string, selector, NBSLanguageReader.c(string2));
    }

    private Feature readProperties(String string, Selector selector, ASTNode aSTNode) throws ParseException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, Pattern> hashMap3 = new HashMap<String, Pattern>();
        for (ASTItem aSTItem : aSTNode.getChildren()) {
            if (aSTItem instanceof ASTToken) continue;
            ASTNode aSTNode2 = (ASTNode)aSTItem;
            String string2 = aSTNode2.getTokenTypeIdentifier("identifier");
            String string3 = aSTNode2.getTokenTypeIdentifier("propertyValue.string");
            if (string3 != null) {
                string3 = string3.substring(1, string3.length() - 1);
                hashMap2.put(string2, NBSLanguageReader.c(string3));
                continue;
            }
            if (aSTNode2.getNode("propertyValue.class") != null) {
                string3 = NBSLanguageReader.readClass(aSTNode2.getNode("propertyValue.class"));
                hashMap.put(string2, string3);
                continue;
            }
            ASTNode aSTNode3 = aSTNode2.getNode("propertyValue.regularExpression");
            Pattern pattern = this.readPattern(aSTNode3, aSTNode2.getOffset());
            hashMap3.put(string2, pattern);
        }
        return Feature.create(string, selector, hashMap2, hashMap, hashMap3);
    }

    private static List<Selector> readSelector(ASTNode aSTNode) {
        return NBSLanguageReader.readSelector(aSTNode, new ArrayList<Selector>());
    }

    private static List<Selector> readSelector(ASTNode aSTNode, List<Selector> list) {
        for (ASTItem aSTItem : aSTNode.getChildren()) {
            if (!(aSTItem instanceof ASTNode)) continue;
            ASTNode aSTNode2 = (ASTNode)aSTItem;
            if (aSTNode2.getNT().equals("class")) {
                list.add(Selector.create(NBSLanguageReader.readClass(aSTNode2)));
                continue;
            }
            if (!aSTNode2.getNT().equals("selector1")) continue;
            NBSLanguageReader.readSelector(aSTNode2, list);
        }
        return list;
    }

    private static String readClass(ASTNode aSTNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(aSTNode.getTokenTypeIdentifier("identifier"));
        for (ASTToken aSTToken : aSTNode.getNode("class1").getChildren()) {
            if (aSTToken.getIdentifier().equals(".")) {
                stringBuilder.append('.');
                continue;
            }
            if (aSTToken.getTypeID() != NBSLanguage.IDENTIFIER_ID) continue;
            stringBuilder.append(aSTToken.getIdentifier());
        }
        return stringBuilder.toString();
    }

    private Pattern readPattern(ASTNode aSTNode, int n) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        NBSLanguageReader.getText(aSTNode, stringBuilder);
        String string = stringBuilder.toString();
        StringInput stringInput = new StringInput(string);
        try {
            return Pattern.create(stringInput);
        }
        catch (ParseException parseException) {
            Point point = Utils.findPosition(this.source, n + stringInput.getIndex());
            throw new ParseException(this.sourceName + " " + point.x + "," + point.y + ": " + parseException.getMessage());
        }
    }

    private static void getText(ASTItem aSTItem, StringBuilder stringBuilder) {
        for (ASTItem aSTItem2 : aSTItem.getChildren()) {
            if (aSTItem2 instanceof ASTNode) {
                NBSLanguageReader.getText(aSTItem2, stringBuilder);
                continue;
            }
            ASTToken aSTToken = (ASTToken)aSTItem2;
            int n = aSTToken.getTypeID();
            if (n == NBSLanguage.COMMENT_ID || n == NBSLanguage.WHITESPACE_ID) continue;
            stringBuilder.append(aSTToken.getIdentifier());
        }
    }

    private static String c(String string) {
        string = string.replace("\\n", "\n");
        string = string.replace("\\r", "\r");
        string = string.replace("\\t", "\t");
        string = string.replace("\\\"", "\"");
        string = string.replace("\\'", "'");
        string = string.replace("\\\\", "\\");
        return string;
    }

    static class Franta {
        private int i = 1;

        Franta() {
        }

        String next(String string) {
            return string + '$' + this.i++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GRNode {
        private boolean isFinal = false;
        private Map<String, GRNode> map;

        private GRNode() {
        }

        GRNode get(String string) {
            GRNode gRNode;
            if (this.map == null) {
                this.map = new HashMap<String, GRNode>();
            }
            if ((gRNode = this.map.get(string)) == null) {
                gRNode = new GRNode();
                this.map.put(string, gRNode);
            }
            return gRNode;
        }

        Set<String> names() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return this.map.keySet();
        }

        void setFinal() {
            this.isFinal = true;
        }

        boolean isFinal() {
            return this.isFinal;
        }

        void put(String string, GRNode gRNode) {
            if (this.map == null) {
                this.map = new HashMap<String, GRNode>();
            }
            this.map.put(string, gRNode);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder, null);
            return stringBuilder.toString();
        }

        private void toString(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
            if (this.isFinal) {
                stringBuilder.append((CharSequence)stringBuilder2).append('\n');
            }
            if (!this.isFinal && this.map == null) {
                stringBuilder.append((CharSequence)stringBuilder2).append('?').append('\n');
            }
            if (this.map == null) {
                return;
            }
            for (String string : this.map.keySet()) {
                if (stringBuilder2 == null) {
                    this.map.get(string).toString(stringBuilder, new StringBuilder(string).append(" ="));
                    continue;
                }
                this.map.get(string).toString(stringBuilder, new StringBuilder(stringBuilder2).append(' ').append(string));
            }
        }
    }
}

