/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.jrctx.JRCTXEditorSupport;
import com.jaspersoft.ireport.designer.jrctx.nodes.properties.ShowTitleProperty;
import com.jaspersoft.ireport.designer.jrctx.nodes.properties.TitleBackgroundPaintProperty;
import com.jaspersoft.ireport.designer.jrctx.nodes.properties.TitleForegroundPaintProperty;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.properties.BoldProperty;
import com.jaspersoft.ireport.designer.sheet.properties.FontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.FontSizeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.ItalicProperty;
import com.jaspersoft.ireport.designer.sheet.properties.PdfEmbeddedProperty;
import com.jaspersoft.ireport.designer.sheet.properties.PdfEncodingProperty;
import com.jaspersoft.ireport.designer.sheet.properties.PdfFontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StrikeThroughProperty;
import com.jaspersoft.ireport.designer.sheet.properties.UnderlineProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.chartthemes.simple.TitleSettings;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseFont;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

public class TitleSettingsNode
extends IRAbstractNode
implements PropertyChangeListener {
    private static final String IMAGE_ICON_BASE = "com/jaspersoft/ireport/designer/resources/chartsettings.png";
    private TitleSettings titleSettings = null;

    public TitleSettingsNode(TitleSettings titleSettings, Lookup doLkp) {
        super(Children.LEAF, doLkp);
        this.titleSettings = titleSettings;
        this.setName("Title Settings");
        this.setIconBaseWithExtension(IMAGE_ICON_BASE);
        titleSettings.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBaseFont)titleSettings.getFont()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JRCTXEditorSupport ed = (JRCTXEditorSupport)((Object)this.getLookup().lookup(JRCTXEditorSupport.class));
        ed.notifyModelChangeToTheView();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new ShowTitleProperty(this.getTitleSettings()));
        set.put((Node.Property)new TitleForegroundPaintProperty(this.getTitleSettings()));
        set.put((Node.Property)new TitleBackgroundPaintProperty(this.getTitleSettings()));
        JRFont font = this.getTitleSettings().getFont();
        set.put((Node.Property)new FontNameProperty(font));
        set.put((Node.Property)new FontSizeProperty(font));
        set.put((Node.Property)new BoldProperty(font));
        set.put((Node.Property)new ItalicProperty(font));
        set.put((Node.Property)new UnderlineProperty(font));
        set.put((Node.Property)new StrikeThroughProperty(font));
        set.put((Node.Property)new PdfFontNameProperty(font));
        set.put((Node.Property)new PdfEmbeddedProperty(font));
        set.put((Node.Property)new PdfEncodingProperty(font));
        sheet.put(set);
        return sheet;
    }

    public TitleSettings getTitleSettings() {
        return this.titleSettings;
    }
}

