/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.errorhandler;

import com.jaspersoft.ireport.designer.compiler.xml.SourceLocation;
import net.sf.jasperreports.engine.design.JRValidationFault;

public class ProblemItem {
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String description = null;
    private String where = "";
    private Object problemReference = null;
    private JRValidationFault fault = null;
    private SourceLocation sourceLocation = null;
    private int problemType = 1;

    public ProblemItem() {
        this(0, "no description available", null);
    }

    public ProblemItem(int problemType, JRValidationFault fault) {
        this.fault = fault;
        this.problemType = problemType;
        if (fault != null) {
            this.description = fault.getMessage();
        }
    }

    public ProblemItem(int problemType, JRValidationFault fault, SourceLocation sl) {
        this.fault = fault;
        this.problemType = problemType;
        if (fault != null) {
            this.description = fault.getMessage();
        }
        this.sourceLocation = sl;
        if (sl != null) {
            this.where = sl.getXPath();
        }
    }

    public ProblemItem(int problemType, String description, Object problemReference) {
        this(0, "no description available", null, "");
    }

    public ProblemItem(int problemType, String description, Object problemReference, String where) {
        this.problemType = problemType;
        this.description = description;
        this.problemReference = problemReference;
        this.where = where;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getProblemReference() {
        if (this.fault != null) {
            return this.fault.getSource();
        }
        return this.problemReference;
    }

    public void setProblemReference(Object problemReference) {
        this.problemReference = problemReference;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public void setProblemType(int problemType) {
        this.problemType = problemType;
    }

    public void resolve() {
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public JRValidationFault getFault() {
        return this.fault;
    }

    public void setFault(JRValidationFault fault) {
        this.fault = fault;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }
}

