/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.designer.connection.MondrianConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.IROlapHierarchy;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.IROlapHierarchyLevel;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.IROlapMemberTuple;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.IROlapResult;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.IROlapResultAxis;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import mondrian.olap.Connection;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;
import net.sf.jasperreports.olap.xmla.JRXmlaResult;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OLAPQueryExecuter {
    private static String soapMessageFactoryClass = null;
    private static String soapConnectionFactoryClass = null;
    private static final Log log = LogFactory.getLog(OLAPQueryExecuter.class);
    private static final String SLICER_AXIS_NAME = "SlicerAxis";
    private static final String MDD_URI = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    private static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    private static final Pattern LEVEL_UNIQUE_NAME_PATTERN = Pattern.compile("\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]");
    private static final int LEVEL_UNIQUE_NAME_PATTERN_NAME_GROUP = 1;
    private SOAPFactory sf;
    private SOAPConnection connection;
    private JROlapResult xmlaResult;
    private Interpreter interpreter = null;
    private List reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();

    public static void setAxisSOAPClientConfig() {
        try {
            if (soapMessageFactoryClass == null && (soapMessageFactoryClass = System.getProperty("javax.xml.soap.MessageFactory")) == null) {
                soapMessageFactoryClass = MessageFactory.newInstance().getClass().getName();
            }
        }
        catch (SOAPException ex) {
            // empty catch block
        }
        try {
            if (soapConnectionFactoryClass == null && (soapConnectionFactoryClass = System.getProperty("javax.xml.soap.SOAPConnectionFactory")) == null) {
                soapConnectionFactoryClass = SOAPConnectionFactory.newInstance().getClass().getName();
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        System.setProperty("javax.xml.soap.MessageFactory", "org.apache.axis.soap.MessageFactoryImpl");
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "org.apache.axis.soap.SOAPConnectionFactoryImpl");
    }

    public static void restoreSOAPClientConfig() {
        if (soapMessageFactoryClass != null) {
            System.setProperty("javax.xml.soap.MessageFactory", soapMessageFactoryClass);
        }
        if (soapConnectionFactoryClass != null) {
            System.setProperty("javax.xml.soap.SOAPConnectionFactory", soapConnectionFactoryClass);
        }
    }

    public OLAPQueryExecuter(String queryStr, List reportParameters) {
        this.setQueryString(queryStr);
        this.setReportParameters(reportParameters);
    }

    public void prepareQuery() throws Exception {
        for (JRDesignParameter param : this.getReportParameters()) {
            Object paramVal;
            String expStr;
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                expStr = param.getDefaultValueExpression() == null ? "" : param.getDefaultValueExpression().getText();
                paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expStr, this.getReportParameters());
                if (paramVal == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            expStr = param.getDefaultValueExpression() == null ? "" : param.getDefaultValueExpression().getText();
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expStr, this.getReportParameters());
            if (paramVal == null) {
                paramVal = "";
            }
            this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
        }
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter1 = new Interpreter();
        interpreter1.setClassLoader(Thread.currentThread().getContextClassLoader());
        return interpreter1;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(List reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    public JROlapResult createOlapResult() throws Exception {
        block14: {
            IReportConnection conn;
            block13: {
                this.prepareQuery();
                conn = IReportManager.getInstance().getDefaultConnection();
                if (!(conn instanceof MondrianConnection)) break block13;
                Connection mconn = ((MondrianConnection)conn).getMondrianConnection();
                if (mconn == null) {
                    throw new Exception("The supplied mondrian.olap.Connection object is null.");
                }
                Query query = mconn.parseQuery(this.queryString);
                this.xmlaResult = new IROlapResult();
                this.parseQuery(query);
                JROlapResult jROlapResult = this.xmlaResult;
                return jROlapResult;
            }
            if (!(conn instanceof JRXMLADataSourceConnection)) break block14;
            JRXMLADataSourceConnection xmlaConnection = (JRXMLADataSourceConnection)conn;
            this.xmlaResult = new JRXmlaResult();
            try {
                OLAPQueryExecuter.setAxisSOAPClientConfig();
                this.sf = SOAPFactory.newInstance();
                this.connection = this.createSOAPConnection();
                SOAPMessage queryMessage = this.createQueryMessage(xmlaConnection);
                queryMessage.writeTo((OutputStream)System.out);
                System.out.println();
                URL soapURL = new URL(this.getSoapUrl(xmlaConnection));
                System.out.println("URL: " + soapURL);
                System.out.flush();
                SOAPMessage resultMessage = this.executeQuery(queryMessage, soapURL);
                this.parseResult(resultMessage);
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
                throw new JRRuntimeException((Throwable)e);
            }
            catch (SOAPException e) {
                log.error((Object)e);
                throw new JRRuntimeException((Throwable)e);
            }
            finally {
                OLAPQueryExecuter.restoreSOAPClientConfig();
            }
            JROlapResult jROlapResult = this.xmlaResult;
            return jROlapResult;
        }
        try {
            throw new Exception("The supplied Connection is not an OLAP connection. An XML/A or Mondrian connection is required.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void parseQuery(Query query) {
        QueryAxis[] axes;
        for (QueryAxis axis : axes = query.getAxes()) {
            Hierarchy[] hierarchies;
            IROlapResultAxis jrAxis = new IROlapResultAxis();
            ((IROlapResult)this.xmlaResult).addAxis(jrAxis);
            for (Hierarchy hierarchy : hierarchies = query.getMdxHierarchiesOnAxis(axis.getAxisOrdinal())) {
                Level[] levels;
                boolean addMeasures = false;
                IROlapHierarchy jrHierarchy = new IROlapHierarchy(hierarchy.getName());
                if (hierarchy.getName().equals("Measures")) {
                    addMeasures = true;
                }
                jrHierarchy.setHierarchyUniqueName(hierarchy.getUniqueName());
                for (Level level : levels = hierarchy.getLevels()) {
                    IROlapHierarchyLevel jrLevel = new IROlapHierarchyLevel(level.getName(), level.getDepth());
                    jrHierarchy.addHierarchyLevel(jrLevel);
                }
                jrAxis.addHierarchy(jrHierarchy);
                if (!addMeasures) continue;
                Set memberSet = query.getMeasuresMembers();
                IROlapMemberTuple tuple = new IROlapMemberTuple();
                for (Member m : memberSet) {
                    JRXmlaMember member = new JRXmlaMember(m.getName(), m.getUniqueName(), m.getDimension().getName(), m.getLevel().getName(), m.getDepth());
                    tuple.addMember((JROlapMember)member);
                }
                jrAxis.addTuple(tuple);
            }
        }
    }

    protected String getSoapUrl(JRXMLADataSourceConnection xmlaConnection) throws MalformedURLException {
        String soapUrl;
        String xmlaUrl = xmlaConnection.getUrl();
        String user = xmlaConnection.getUsername();
        if (user == null || user.length() == 0) {
            soapUrl = xmlaUrl;
        } else {
            URL url = new URL(xmlaUrl);
            soapUrl = url.getProtocol() + "://" + user;
            String password = xmlaConnection.getPassword();
            if (password != null && password.length() > 0) {
                soapUrl = soapUrl + ":" + password;
            }
            soapUrl = soapUrl + "@" + url.getHost() + ":" + url.getPort() + url.getPath();
        }
        return soapUrl;
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SOAPException e) {
                log.error((Object)e);
                throw new JRRuntimeException((Throwable)e);
            }
            this.connection = null;
        }
    }

    protected SOAPConnection createSOAPConnection() {
        try {
            SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = scf.createConnection();
            return soapConnection;
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)e);
            throw new JRRuntimeException((Throwable)e);
        }
        catch (SOAPException e) {
            log.error((Object)e);
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected SOAPMessage createQueryMessage(JRXMLADataSourceConnection xmlaConnection) {
        String queryStr = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("MDX query: " + queryStr));
        }
        try {
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage message = mf.createMessage();
            MimeHeaders mh = message.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nEx = envelope.createName("Execute", "", XMLA_URI);
            SOAPElement eEx = body.addChildElement(nEx);
            Name nCom = envelope.createName("Command", "", XMLA_URI);
            SOAPElement eCommand = eEx.addChildElement(nCom);
            Name nSta = envelope.createName("Statement", "", XMLA_URI);
            SOAPElement eStatement = eCommand.addChildElement(nSta);
            eStatement.addTextNode(queryStr);
            HashMap<String, String> paraList = new HashMap<String, String>();
            String datasource = xmlaConnection.getDatasource();
            paraList.put("DataSourceInfo", datasource);
            String catalog = xmlaConnection.getCatalog();
            paraList.put("Catalog", catalog);
            paraList.put("Format", "Multidimensional");
            paraList.put("AxisFormat", "TupleFormat");
            this.addParameterList(envelope, eEx, "Properties", "PropertyList", paraList);
            message.saveChanges();
            if (log.isDebugEnabled()) {
                log.debug((Object)("XML/A query message: " + message.toString()));
            }
            return message;
        }
        catch (SOAPException e) {
            log.error((Object)e);
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected void addParameterList(SOAPEnvelope envelope, SOAPElement eParent, String typeName, String listName, Map params) throws SOAPException {
        Name nPara = envelope.createName(typeName, "", XMLA_URI);
        SOAPElement eType = eParent.addChildElement(nPara);
        nPara = envelope.createName(listName, "", XMLA_URI);
        SOAPElement eList = eType.addChildElement(nPara);
        if (params == null) {
            return;
        }
        for (String tag : params.keySet()) {
            String value = (String)params.get(tag);
            nPara = envelope.createName(tag, "", XMLA_URI);
            SOAPElement eTag = eList.addChildElement(nPara);
            eTag.addTextNode(value);
        }
    }

    protected SOAPMessage executeQuery(SOAPMessage message, URL url) {
        try {
            SOAPMessage soapResult = this.connection.call(message, (Object)url);
            return soapResult;
        }
        catch (SOAPException e) {
            log.error((Object)"Message-Call failed.", (Throwable)e);
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected void parseResult(SOAPMessage reply) throws SOAPException, JRRuntimeException {
        Object eObj;
        Object eObj2;
        Object eObj3;
        Object eObj4;
        Object eObj5;
        Name eName;
        Iterator responseElements;
        SOAPFault fault;
        SOAPPart soapPart = reply.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement eElement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("XML/A result envelope: " + soapEnvelope.toString()));
        }
        if ((fault = soapBody.getFault()) != null) {
            this.handleResultFault(fault);
        }
        if ((responseElements = soapBody.getChildElements(eName = soapEnvelope.createName("ExecuteResponse", "", XMLA_URI))).hasNext()) {
            eObj5 = responseElements.next();
            if (eObj5 == null) {
                log.error((Object)"ExecuteResponse Element is null.");
                throw new JRRuntimeException("ExecuteResponse Element is null.");
            }
        } else {
            log.error((Object)"Could not retrieve ExecuteResponse Element.");
            throw new JRRuntimeException("Could not retrieve ExecuteResponse Element.");
        }
        eElement = (SOAPElement)eObj5;
        Name rName = soapEnvelope.createName("return", "", XMLA_URI);
        Iterator returnElements = eElement.getChildElements(rName);
        SOAPElement returnElement = null;
        if (returnElements.hasNext()) {
            Object eObj6 = returnElements.next();
            if (eObj6 == null) {
                log.error((Object)"return Element is null.");
                throw new JRRuntimeException("return Element is null.");
            }
            returnElement = (SOAPElement)eObj6;
        } else {
            Name rName2 = soapEnvelope.createName("return", "", "");
            returnElements = eElement.getChildElements(rName2);
            if (returnElements.hasNext()) {
                Object eObj7 = returnElements.next();
                if (eObj7 == null) {
                    log.error((Object)"return Element is null.");
                    throw new JRRuntimeException("return Element is null.");
                }
                returnElement = (SOAPElement)eObj7;
            } else {
                log.error((Object)"Could not retrieve return Element.");
                throw new JRRuntimeException("Could not retrieve return Element.");
            }
        }
        Name rootName = soapEnvelope.createName("root", "", MDD_URI);
        SOAPElement rootElement = null;
        Iterator rootElements = returnElement.getChildElements(rootName);
        if (rootElements.hasNext()) {
            eObj4 = rootElements.next();
            if (eObj4 == null) {
                log.error((Object)"root Element is null.");
                throw new JRRuntimeException("root Element is null.");
            }
        } else {
            log.error((Object)"Could not retrieve root Element.");
            throw new JRRuntimeException("Could not retrieve root Element.");
        }
        rootElement = (SOAPElement)eObj4;
        Name olapInfoName = soapEnvelope.createName("OlapInfo", "", MDD_URI);
        SOAPElement olapInfoElement = null;
        Iterator olapInfoElements = rootElement.getChildElements(olapInfoName);
        if (olapInfoElements.hasNext()) {
            eObj3 = olapInfoElements.next();
            if (eObj3 == null) {
                log.error((Object)"OlapInfo Element is null.");
                throw new JRRuntimeException("OlapInfo Element is null.");
            }
        } else {
            log.error((Object)"Could not retrieve OlapInfo Element.");
            throw new JRRuntimeException("Could not retrieve OlapInfo Element.");
        }
        olapInfoElement = (SOAPElement)eObj3;
        this.parseOLAPInfoElement(olapInfoElement);
        Name axesName = soapEnvelope.createName("Axes", "", MDD_URI);
        SOAPElement axesElement = null;
        Iterator axesElements = rootElement.getChildElements(axesName);
        if (axesElements.hasNext()) {
            eObj2 = axesElements.next();
            if (eObj2 == null) {
                log.error((Object)"Axes Element is null");
                throw new JRRuntimeException("Axes Element is null");
            }
        } else {
            log.error((Object)"Could not retrieve Axes Element.");
            throw new JRRuntimeException("Could not retrieve Axes Element.");
        }
        axesElement = (SOAPElement)eObj2;
        this.parseAxesElement(axesElement);
        Name cellDataName = soapEnvelope.createName("CellData", "", MDD_URI);
        SOAPElement cellDataElement = null;
        Iterator cellDataElements = rootElement.getChildElements(cellDataName);
        if (cellDataElements.hasNext()) {
            eObj = cellDataElements.next();
            if (eObj == null) {
                log.error((Object)"CellData element is null");
                throw new JRRuntimeException("CellData element is null");
            }
        } else {
            log.error((Object)"Could not retrieve CellData Element.");
            throw new JRRuntimeException("Could not retrieve CellData Element.");
        }
        cellDataElement = (SOAPElement)eObj;
        this.parseCellDataElement(cellDataElement);
    }

    protected void handleResultFault(SOAPFault fault) {
        String faultCode;
        String faultActor;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("XML/A fault: ");
        String faultString = fault.getFaultString();
        if (faultString != null) {
            errorMsg.append(faultString);
            errorMsg.append("; ");
        }
        if ((faultActor = fault.getFaultActor()) != null) {
            errorMsg.append("Actor: ");
            errorMsg.append(faultActor);
            errorMsg.append("; ");
        }
        if ((faultCode = fault.getFaultCode()) != null) {
            errorMsg.append("Code: ");
            errorMsg.append(faultCode);
            errorMsg.append("; ");
        }
        throw new JRRuntimeException(errorMsg.toString());
    }

    protected void parseOLAPInfoElement(SOAPElement olapInfoElement) throws SOAPException {
        Object axesObj;
        Name axesInfoName = this.sf.createName("AxesInfo", "", MDD_URI);
        SOAPElement axesElement = null;
        Iterator axesInfoElements = olapInfoElement.getChildElements(axesInfoName);
        if (axesInfoElements.hasNext()) {
            axesObj = axesInfoElements.next();
            if (axesObj == null) {
                log.error((Object)"AxisInfo Element is null.");
                throw new JRRuntimeException("AxisInfo Element is null.");
            }
        } else {
            log.error((Object)"Could not retrieve AxesInfo Element.");
            throw new JRRuntimeException("Could not retrieve AxesInfo Element.");
        }
        axesElement = (SOAPElement)axesObj;
        this.parseAxesInfoElement(axesElement);
    }

    protected void parseAxesInfoElement(SOAPElement axesInfoElement) throws SOAPException {
        Name axisInfoName = this.sf.createName("AxisInfo", "", MDD_URI);
        Iterator itAxis = axesInfoElement.getChildElements(axisInfoName);
        while (itAxis.hasNext()) {
            Name name;
            SOAPElement axisElement = (SOAPElement)itAxis.next();
            String axisName = axisElement.getAttributeValue(name = this.sf.createName("name"));
            if (axisName.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis axis = new JRXmlaResultAxis(axisName);
            ((JRXmlaResult)this.xmlaResult).addAxis(axis);
            name = this.sf.createName("HierarchyInfo", "", MDD_URI);
            Iterator itHierInfo = axisElement.getChildElements(name);
            while (itHierInfo.hasNext()) {
                SOAPElement eHierInfo = (SOAPElement)itHierInfo.next();
                this.handleHierInfo(axis, eHierInfo);
            }
        }
    }

    protected void parseAxesElement(SOAPElement axesElement) throws SOAPException {
        Name aName = this.sf.createName("Axis", "", MDD_URI);
        Iterator itAxis = axesElement.getChildElements(aName);
        while (itAxis.hasNext()) {
            Name name;
            SOAPElement axisElement = (SOAPElement)itAxis.next();
            String axisName = axisElement.getAttributeValue(name = this.sf.createName("name"));
            if (axisName.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis axis = ((JRXmlaResult)this.xmlaResult).getAxisByName(axisName);
            name = this.sf.createName("Tuples", "", MDD_URI);
            Iterator itTuples = axisElement.getChildElements(name);
            if (!itTuples.hasNext()) continue;
            SOAPElement eTuples = (SOAPElement)itTuples.next();
            this.handleTuplesElement(axis, eTuples);
        }
    }

    protected void parseCellDataElement(SOAPElement cellDataElement) throws SOAPException {
        Name name = this.sf.createName("Cell", "", MDD_URI);
        Iterator itCells = cellDataElement.getChildElements(name);
        while (itCells.hasNext()) {
            Name errorName;
            SOAPElement cellElement = (SOAPElement)itCells.next();
            Iterator errorElems = cellElement.getChildElements(errorName = this.sf.createName("Error", "", MDD_URI));
            if (errorElems.hasNext()) {
                this.handleCellErrors(errorElems);
            }
            Name ordinalName = this.sf.createName("CellOrdinal");
            String cellOrdinal = cellElement.getAttributeValue(ordinalName);
            Object value = null;
            Iterator valueElements = cellElement.getChildElements(this.sf.createName("Value", "", MDD_URI));
            if (valueElements.hasNext()) {
                SOAPElement valueElement = (SOAPElement)valueElements.next();
                String valueType = valueElement.getAttribute("xsi:type");
                value = valueType.equals("xsd:int") ? new Long(valueElement.getValue()) : (valueType.equals("xsd:double") ? new Double(valueElement.getValue()) : (valueType.equals("xsd:decimal") ? new Double(valueElement.getValue()) : valueElement.getValue()));
            }
            String fmtValue = "";
            Iterator fmtValueElements = cellElement.getChildElements(this.sf.createName("FmtValue", "", MDD_URI));
            if (fmtValueElements.hasNext()) {
                SOAPElement fmtValueElement = (SOAPElement)fmtValueElements.next();
                fmtValue = fmtValueElement.getValue();
            }
            int pos = Integer.parseInt(cellOrdinal);
            JRXmlaCell cell = new JRXmlaCell(value, fmtValue);
            ((JRXmlaResult)this.xmlaResult).setCell(cell, pos);
        }
    }

    protected void handleCellErrors(Iterator errorElems) throws SOAPException {
        Iterator codeElems;
        Iterator sourceElems;
        SOAPElement errorElem = (SOAPElement)errorElems.next();
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("Cell error: ");
        Iterator descriptionElems = errorElem.getChildElements(this.sf.createName("Description", "", MDD_URI));
        if (descriptionElems.hasNext()) {
            SOAPElement descrElem = (SOAPElement)descriptionElems.next();
            errorMsg.append(descrElem.getValue());
            errorMsg.append("; ");
        }
        if ((sourceElems = errorElem.getChildElements(this.sf.createName("Source", "", MDD_URI))).hasNext()) {
            SOAPElement sourceElem = (SOAPElement)sourceElems.next();
            errorMsg.append("Source: ");
            errorMsg.append(sourceElem.getValue());
            errorMsg.append("; ");
        }
        if ((codeElems = errorElem.getChildElements(this.sf.createName("ErrorCode", "", MDD_URI))).hasNext()) {
            SOAPElement codeElem = (SOAPElement)codeElems.next();
            errorMsg.append("Code: ");
            errorMsg.append(codeElem.getValue());
            errorMsg.append("; ");
        }
        throw new JRRuntimeException(errorMsg.toString());
    }

    protected void handleHierInfo(JRXmlaResultAxis axis, SOAPElement hierInfoElement) throws SOAPException {
        Name name = this.sf.createName("name");
        String dimName = hierInfoElement.getAttributeValue(name);
        JRXmlaHierarchy hier = new JRXmlaHierarchy(dimName);
        axis.addHierarchy(hier);
    }

    protected void handleTuplesElement(JRXmlaResultAxis axis, SOAPElement tuplesElement) throws SOAPException {
        Name tName = this.sf.createName("Tuple", "", MDD_URI);
        Iterator itTuple = tuplesElement.getChildElements(tName);
        while (itTuple.hasNext()) {
            SOAPElement eTuple = (SOAPElement)itTuple.next();
            this.handleTupleElement(axis, eTuple);
        }
    }

    protected void handleTupleElement(JRXmlaResultAxis axis, SOAPElement tupleElement) throws SOAPException {
        JRXmlaMemberTuple tuple = new JRXmlaMemberTuple(axis.getHierarchiesOnAxis().length);
        Name memName = this.sf.createName("Member", "", MDD_URI);
        Iterator itMember = tupleElement.getChildElements(memName);
        int memNum = 0;
        while (itMember.hasNext()) {
            String levelUniqueName;
            Matcher matcher;
            SOAPElement memElement = (SOAPElement)itMember.next();
            Name name = this.sf.createName("Hierarchy", "", "");
            String hierName = memElement.getAttributeValue(name);
            String uName = "";
            Iterator uNameElements = memElement.getChildElements(this.sf.createName("UName", "", MDD_URI));
            if (uNameElements.hasNext()) {
                uName = ((SOAPElement)uNameElements.next()).getValue();
            }
            String caption = "";
            Iterator captionElements = memElement.getChildElements(this.sf.createName("Caption", "", MDD_URI));
            if (captionElements.hasNext()) {
                caption = ((SOAPElement)captionElements.next()).getValue();
            }
            String lName = "";
            Iterator lNameElements = memElement.getChildElements(this.sf.createName("LName", "", MDD_URI));
            if (lNameElements.hasNext() && (matcher = LEVEL_UNIQUE_NAME_PATTERN.matcher(levelUniqueName = ((SOAPElement)lNameElements.next()).getValue())).matches()) {
                lName = matcher.group(1);
            }
            int lNum = 0;
            Iterator lNumElements = memElement.getChildElements(this.sf.createName("LNum", "", MDD_URI));
            if (lNumElements.hasNext()) {
                lNum = Integer.parseInt(((SOAPElement)lNumElements.next()).getValue());
            }
            JRXmlaMember member = new JRXmlaMember(caption, uName, hierName, lName, lNum);
            tuple.setMember(memNum++, member);
        }
        axis.addTuple(tuple);
    }
}

