/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;

final class JRFloatSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRFloatSumIncrementer mainInstance = new JRFloatSumIncrementer();

    private JRFloatSumIncrementer() {
    }

    public static JRFloatSumIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRFloatIncrementerFactory.ZERO;
        }
        return new Float(value.floatValue() + newValue.floatValue());
    }

    public Object initialValue() {
        return JRFloatIncrementerFactory.ZERO;
    }
}

