/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.standalone.IReportStandaloneManager;
import com.jaspersoft.ireport.designer.standalone.actions.RecentFiles;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.actions.Presenter;

public class RecentFileAction
extends AbstractAction
implements Presenter.Menu,
PopupMenuListener {
    private static final String FO_PROP = "RecentFileAction.Recent_FO";
    private static final int MAX_COUNT = 15;
    private JMenu menu;
    private static RecentFileAction theInstance = null;

    public static RecentFileAction getInstance() {
        return theInstance;
    }

    public RecentFileAction() {
        super(I18n.getString(IReportStandaloneManager.class, (String)"LBL_RecentFileAction_Name"));
        RecentFiles.init();
        theInstance = this;
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new JMenu(this);
            this.menu.setMnemonic(I18n.getString(IReportStandaloneManager.class, (String)"MNE_RecentFileAction_Name").charAt(0));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RecentFileAction.this.updateSubMenu();
                    RecentFileAction.this.menu.updateUI();
                }
            });
        }
        return this.menu;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        this.updateSubMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this.menu.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    public void updateSubMenu() {
        List<String> files = RecentFiles.getRecentFiles();
        this.menu.removeAll();
        this.menu.setEnabled(files.size() != 0);
        int counter = 0;
        for (String hItem : files) {
            try {
                FileObject fo = RecentFiles.convertURL2File(new URL(hItem));
                if (fo == null) continue;
                if (++counter > 15) break;
                Image icon = null;
                try {
                    DataObject dObj = DataObject.find((FileObject)fo);
                    icon = dObj.getNodeDelegate().getIcon(1);
                }
                catch (DataObjectNotFoundException ex) {
                    Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    continue;
                }
                JMenuItem jmi = null;
                jmi = icon != null ? new JMenuItem(fo.getNameExt(), new ImageIcon(icon)) : new JMenuItem(fo.getNameExt());
                jmi.putClientProperty(FO_PROP, fo);
                jmi.addActionListener(this);
                this.menu.add(jmi);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JMenuItem source = (JMenuItem)evt.getSource();
        FileObject fo = (FileObject)source.getClientProperty(FO_PROP);
        if (fo != null) {
            try {
                ((OpenCookie)DataObject.find((FileObject)fo).getCookie(OpenCookie.class)).open();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

