/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.ServerDialog;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FolderNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.resources.DataSourceDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.DataTypeDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.InputControlDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ListOfValuesDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ObjectPropertiesDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.QueryDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ReportOptionsDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ReportUnitDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ResourceReferenceDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.XMLAConnectionDialog;
import java.util.List;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class PropertiesAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(PropertiesAction.class, (String)"CTL_PropertiesAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (!(activatedNodes[0] instanceof ResourceNode)) {
            return;
        }
        ResourceNode node = (ResourceNode)activatedNodes[0];
        RepositoryFolder rf = ((ResourceNode)activatedNodes[0]).getRepositoryObject();
        if (activatedNodes[0] instanceof FolderNode) {
            if (rf.isRoot()) {
                JServer server = rf.getServer();
                ServerDialog sd = new ServerDialog(Misc.getMainFrame(), true);
                sd.setJServer(server);
                sd.setVisible(true);
                if (sd.getDialogResult() == 0) {
                    server.setName(sd.getJServer().getName());
                    server.setUsername(sd.getJServer().getUsername());
                    server.setPassword(sd.getJServer().getPassword());
                    server.setUrl(sd.getJServer().getUrl());
                    rf.getDescriptor().setLabel(server.getName());
                    JasperServerManager.getMainInstance().saveConfiguration();
                    node.updateDisplayName();
                }
            } else {
                ObjectPropertiesDialog opd = new ObjectPropertiesDialog(Misc.getMainFrame(), true);
                opd.setResource(rf);
                opd.setVisible(true);
                if (opd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            }
        } else if (rf instanceof RepositoryReportUnit) {
            RepositoryReportUnit rru = (RepositoryReportUnit)rf;
            ReportUnitDialog rrd = new ReportUnitDialog(Misc.getMainFrame(), true);
            rrd.setParentFolder(rru.getDescriptor().getParentFolder());
            rrd.setServer(rru.getServer());
            rrd.setControlsSupportActive(false);
            rrd.setResourcesSupportActive(false);
            List datasources = null;
            if (JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                try {
                    datasources = rru.getServer().getWSClient().listDatasources();
                    rrd.setDatasources(datasources);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            rrd.setResource(rru);
            rrd.setVisible(true);
            if (rrd.getDialogResult() == 0) {
                node.updateDisplayName();
            }
        } else if (rf instanceof RepositoryFile) {
            if (rf.getDescriptor().getWsType().equals("jdbc") || rf.getDescriptor().getWsType().equals("jndi") || rf.getDescriptor().getWsType().equals("bean")) {
                DataSourceDialog dsd = new DataSourceDialog(Misc.getMainFrame(), true);
                dsd.setParentFolder(rf.getDescriptor().getParentFolder());
                dsd.setServer(rf.getServer());
                dsd.setResource(rf);
                dsd.setVisible(true);
                if (dsd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("olapXmlaCon")) {
                XMLAConnectionDialog dsd = new XMLAConnectionDialog(Misc.getMainFrame(), true);
                dsd.setParentFolder(rf.getDescriptor().getParentFolder());
                dsd.setServer(rf.getServer());
                dsd.setResource(rf);
                dsd.setVisible(true);
                if (dsd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("reference")) {
                ResourceReferenceDialog rrd = new ResourceReferenceDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("dataType")) {
                DataTypeDialog rrd = new DataTypeDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("lov")) {
                ListOfValuesDialog rrd = new ListOfValuesDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("query")) {
                QueryDialog rrd = new QueryDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                List datasources = null;
                if (JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                    try {
                        datasources = rf.getServer().getWSClient().listDatasources();
                        rrd.setDatasources(datasources);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                        ex.printStackTrace();
                    }
                }
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("inputControl")) {
                InputControlDialog rrd = new InputControlDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else if (rf.getDescriptor().getWsType().equals("ReportOptionsResource")) {
                ReportOptionsDialog rrd = new ReportOptionsDialog(Misc.getMainFrame(), true);
                rrd.setParentFolder(rf.getDescriptor().getParentFolder());
                rrd.setServer(rf.getServer());
                rrd.setResource(rf);
                rrd.setVisible(true);
                if (rrd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            } else {
                ObjectPropertiesDialog opd = new ObjectPropertiesDialog(Misc.getMainFrame(), true);
                opd.setResource(rf);
                opd.setVisible(true);
                if (opd.getDialogResult() == 0) {
                    node.updateDisplayName();
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ResourceNode;
    }
}

