/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.util.UnsupportedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAxis
implements Axis {
    private static final Logger LOGGER = Logger.getLogger(RolapAxis.class);

    public static String toString(Axis axis) {
        List<Position> pl = axis.getPositions();
        return RolapAxis.toString(pl);
    }

    public static String toString(List<Position> pl) {
        StringBuilder buf = new StringBuilder();
        for (Position p : pl) {
            buf.append('{');
            boolean firstTime = true;
            for (Member m : p) {
                if (!firstTime) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
                firstTime = false;
            }
            buf.append('}');
            buf.append('\n');
        }
        return buf.toString();
    }

    protected RolapAxis() {
    }

    @Override
    public abstract List<Position> getPositions();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionListBase
    extends PositionListUnsupported {
        protected PositionListBase() {
        }

        @Override
        public abstract int size();

        @Override
        public abstract boolean isEmpty();

        @Override
        public abstract Position get(int var1);

        @Override
        public ListIterator<Position> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Position> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Position> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionIterBase
    extends PositionListUnsupported {
        protected PositionIterBase() {
        }

        @Override
        public abstract Iterator<Position> iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionListUnsupported
    extends UnsupportedList<Position> {
        protected PositionListUnsupported() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionBase
    extends PositionUnsupported {
        protected PositionBase() {
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            List that = (List)o;
            int size = this.size();
            if (size != that.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                Member m1 = (Member)this.get(i);
                Object m2 = that.get(i);
                if (m1 != null ? m1.equals(m2) : m2 == null) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Member obj = (Member)this.get(i);
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }

        @Override
        public ListIterator<Member> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Member> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Member> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionUnsupported
    extends UnsupportedList<Member>
    implements Position {
        protected PositionUnsupported() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayList
    extends RolapAxis {
        private final List<Member[]> list;
        private final int len;

        public MemberArrayList(List<Member[]> list) {
            this.list = list;
            this.len = list.size() == 0 ? 0 : list.get(0).length;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        class MemberArrayListPosition
        extends PositionBase {
            protected final int offset;

            MemberArrayListPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayList.this.len;
            }

            public Member get(int index) {
                if (index > MemberArrayList.this.len) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayList.this.len);
                }
                return ((Member[])MemberArrayList.this.list.get(this.offset))[index];
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberArrayList.this.list.size();
            }

            public boolean isEmpty() {
                return MemberArrayList.this.list.isEmpty();
            }

            public Position get(int index) {
                if (index >= MemberArrayList.this.list.size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new MemberArrayListPosition(index);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayIterable
    extends RolapAxis {
        private Iterable<Member[]> iter;
        private List<Member[]> list;
        private int len;

        public MemberArrayIterable(Iterable<Member[]> iter) {
            this.iter = iter;
            this.list = null;
            this.len = 0;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator<Member[]> it = this.iter.iterator();
                this.list = new ArrayList<Member[]>();
                while (it.hasNext()) {
                    this.list.add(it.next());
                }
                this.iter = null;
                this.len = this.list.size() == 0 ? 0 : this.list.get(0).length;
            }
        }

        class MemberArrayListPosition
        extends PositionBase {
            protected final int offset;

            MemberArrayListPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayIterable.this.len;
            }

            public Member get(int index) {
                if (index > MemberArrayIterable.this.len) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayIterable.this.len);
                }
                return ((Member[])MemberArrayIterable.this.list.get(this.offset))[index];
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public boolean isEmpty() {
                return MemberArrayIterable.this.list.isEmpty();
            }

            public int size() {
                return MemberArrayIterable.this.list.size();
            }

            public Position get(int index) {
                return new MemberArrayListPosition(index);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MemberIterPosition
        extends PositionBase {
            Member[] members;

            MemberIterPosition(Member[] members) {
                this.members = members;
            }

            @Override
            public int size() {
                return this.members.length;
            }

            @Override
            public Member get(int index) {
                return this.members[index];
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MemberIterPosition.this.members.length;
                    }

                    @Override
                    public Member next() {
                        return MemberIterPosition.this.members[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member[]> it;

            PositionIter() {
                this.it = MemberArrayIterable.this.iter.iterator();
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){
                    int nextCnt = 0;

                    @Override
                    public boolean hasNext() {
                        return PositionIter.this.it.hasNext();
                    }

                    @Override
                    public Position next() {
                        ++this.nextCnt;
                        return new MemberIterPosition((Member[])PositionIter.this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("PositionWrapper.materialize: Member[] iter.class=" + (MemberArrayIterable.this.iter != null ? MemberArrayIterable.this.iter.getClass().getName() : null)));
                }
                MemberArrayIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberList
    extends RolapAxis {
        private final List<Member> list;

        public MemberList(List<Member> list) {
            this.list = list;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        class MemberListPosition
        extends PositionBase {
            protected final int offset;

            MemberListPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberList.this.list.get(this.offset);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            @Override
            public int size() {
                return MemberList.this.list.size();
            }

            @Override
            public boolean isEmpty() {
                return MemberList.this.list.isEmpty();
            }

            @Override
            public Position get(int index) {
                return new MemberListPosition(index);
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){
                    private final Iterator it;
                    private int cursor;
                    {
                        this.it = MemberList.this.list.iterator();
                        this.cursor = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Position next() {
                        this.it.next();
                        return PositionList.this.get(this.cursor++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberIterable
    extends RolapAxis {
        private Iterable<Member> iter;
        private List<Member> list;

        public MemberIterable(Iterable<Member> iter) {
            this.iter = iter;
            this.list = null;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator<Member> it = this.iter.iterator();
                this.list = new ArrayList<Member>();
                while (it.hasNext()) {
                    this.list.add(it.next());
                }
                this.iter = null;
            }
        }

        class MemberListPosition
        extends PositionBase {
            protected final int offset;

            MemberListPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberIterable.this.list.get(this.offset);
            }
        }

        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public boolean isEmpty() {
                return MemberIterable.this.list.isEmpty();
            }

            public int size() {
                return MemberIterable.this.list.size();
            }

            public Position get(int index) {
                return new MemberListPosition(index);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MemberIterPosition
        extends PositionBase {
            Member member;

            MemberIterPosition(Member member) {
                this.member = member;
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return this.member;
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){

                    @Override
                    public boolean hasNext() {
                        return MemberIterPosition.this.member != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Member next() {
                        try {
                            Member member = MemberIterPosition.this.member;
                            return member;
                        }
                        finally {
                            MemberIterPosition.this.member = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member> it;

            PositionIter() {
                this.it = MemberIterable.this.iter.iterator();
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){

                    @Override
                    public boolean hasNext() {
                        return PositionIter.this.it.hasNext();
                    }

                    @Override
                    public Position next() {
                        return new MemberIterPosition((Member)PositionIter.this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("PositionWrapper.materialize: Member iter.class=" + MemberIterable.this.iter.getClass().getName()));
                }
                MemberIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleEmptyPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return Collections.singletonList(new EmptyPosition());
        }

        static class EmptyPosition
        extends PositionBase {
            EmptyPosition() {
            }

            public int size() {
                return 0;
            }

            public Member get(int index) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PositionList
    extends RolapAxis {
        protected final List<Position> positions;

        public PositionList(List<Position> positions) {
            this.positions = positions;
        }

        @Override
        public List<Position> getPositions() {
            return this.positions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Wrapper
    extends RolapAxis {
        private final Axis axis;

        protected Wrapper(Axis axis) {
            this.axis = axis;
        }

        @Override
        public List<Position> getPositions() {
            return this.axis.getPositions();
        }
    }
}

