/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.List;
import mondrian.olap.DrillThrough;
import mondrian.olap.MondrianException;
import mondrian.olap.Query;
import mondrian.olap.QueryCanceledException;
import mondrian.olap.QueryPart;
import mondrian.olap.QueryTimeoutException;
import mondrian.olap4j.MondrianOlap4jCell;
import mondrian.olap4j.MondrianOlap4jCellSet;
import mondrian.olap4j.MondrianOlap4jConnection;
import org.olap4j.CellSet;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jStatement
implements OlapStatement {
    final MondrianOlap4jConnection olap4jConnection;
    private boolean closed;
    MondrianOlap4jCellSet openCellSet;
    int timeoutSeconds;

    MondrianOlap4jStatement(MondrianOlap4jConnection olap4jConnection) {
        assert (olap4jConnection != null);
        this.olap4jConnection = olap4jConnection;
        this.closed = false;
    }

    public ResultSet executeQuery(String mdx) throws SQLException {
        QueryPart parseTree;
        try {
            parseTree = this.olap4jConnection.connection.parseStatement(mdx);
        }
        catch (MondrianException e) {
            throw this.olap4jConnection.helper.createException("mondrian gave exception while parsing query", e);
        }
        if (!(parseTree instanceof DrillThrough)) {
            throw this.olap4jConnection.helper.createException("Query does not have relational result. Use a DRILLTHROUGH query, or execute using the executeOlapQuery method.");
        }
        DrillThrough drillThrough = (DrillThrough)parseTree;
        CellSet cellSet = this.executeOlapQueryInternal(drillThrough.getQuery());
        List<Integer> coords = Collections.nCopies(cellSet.getAxes().size(), 0);
        MondrianOlap4jCell cell = (MondrianOlap4jCell)cellSet.getCell(coords);
        return cell.drillThroughInternal(drillThrough.getMaxRowCount(), drillThrough.getFirstRowOrdinal());
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw this.olap4jConnection.helper.createException("closed");
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.openCellSet != null) {
                MondrianOlap4jCellSet c = this.openCellSet;
                this.openCellSet = null;
                c.close();
            }
        }
    }

    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeoutSeconds;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.olap4jConnection.helper.createException("illegal timeout value " + seconds);
        }
        this.timeoutSeconds = seconds;
    }

    public synchronized void cancel() throws SQLException {
        if (this.openCellSet != null) {
            this.openCellSet.query.cancel();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.olap4jConnection.helper.createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public CellSet executeOlapQuery(String mdx) throws OlapException {
        Query query;
        try {
            query = this.olap4jConnection.connection.parseQuery(mdx);
        }
        catch (MondrianException e) {
            throw this.olap4jConnection.helper.createException("mondrian gave exception while parsing query", e);
        }
        return this.executeOlapQueryInternal(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CellSet executeOlapQueryInternal(Query query) throws OlapException {
        MondrianOlap4jStatement mondrianOlap4jStatement = this;
        synchronized (mondrianOlap4jStatement) {
            if (this.openCellSet != null) {
                MondrianOlap4jCellSet cs = this.openCellSet;
                this.openCellSet = null;
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    throw this.olap4jConnection.helper.createException(null, "Error while closing previous CellSet", e);
                }
            }
            this.openCellSet = this.olap4jConnection.factory.newCellSet(this, query);
        }
        try {
            this.openCellSet.execute();
        }
        catch (QueryCanceledException e) {
            throw this.olap4jConnection.helper.createException("Query canceled");
        }
        catch (QueryTimeoutException e) {
            throw this.olap4jConnection.helper.createException(e.getMessage());
        }
        return this.openCellSet;
    }

    public CellSet executeOlapQuery(SelectNode selectNode) throws OlapException {
        String mdx = MondrianOlap4jStatement.toString((ParseTreeNode)selectNode);
        return this.executeOlapQuery(mdx);
    }

    private static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(pw);
        node.unparse(parseTreeWriter);
        pw.flush();
        return sw.toString();
    }
}

