/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import org.eigenbase.resgen.Generator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;

abstract class AbstractGenerator
implements Generator {
    private final File srcFile;
    private final File file;
    private Boolean scmSafeComments = null;

    public AbstractGenerator(File file, File file2) {
        this.srcFile = file;
        this.file = file2;
    }

    public void setScmSafeComments(boolean bl) {
        if (this.scmSafeComments != null) {
            throw new AssertionError((Object)"SCM safe comment style may only be configured once.");
        }
        this.scmSafeComments = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean useScmSafeComments() {
        return this.scmSafeComments != null && this.scmSafeComments != false;
    }

    protected abstract void generateResource(ResourceDef.Resource var1, PrintWriter var2);

    protected void generateDoNotModifyHeader(PrintWriter printWriter) {
        if (this.useScmSafeComments()) {
            printWriter.println("// This class is generated. Do NOT modify it manually.");
        } else {
            printWriter.println("// This class is generated. Do NOT modify it, or");
            printWriter.println("// add it to source control.");
        }
        printWriter.println();
    }

    protected void generateGeneratedByBlock(PrintWriter printWriter) {
        printWriter.println("/**");
        printWriter.println(" * This class was generated");
        printWriter.println(" * by " + ResourceGen.class);
        String string = this.getSrcFileForComment();
        printWriter.println(" * from " + string);
        if (!this.useScmSafeComments()) {
            printWriter.println(" * on " + new Date().toString() + ".");
        }
        printWriter.println(" * It contains a list of messages, and methods to");
        printWriter.println(" * retrieve and format those messages.");
        printWriter.println(" */");
        printWriter.println();
    }

    protected File getFile() {
        return this.file;
    }

    protected String getSrcFileForComment() {
        int n;
        String string = this.srcFile.toString().replace('\\', '/');
        if (this.useScmSafeComments() && (n = string.lastIndexOf(47)) > 0) {
            string = "..." + string.substring(n);
        }
        return string;
    }

    protected abstract String getClassName();

    protected abstract String getBaseClassName();

    protected String getParameterList(String string) {
        String[] stringArray = this.getArgTypes(string);
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
            if (!string2.endsWith("&") && !string2.endsWith("*")) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("p");
            stringBuffer.append(Integer.toString(i));
        }
        return stringBuffer.toString();
    }

    protected abstract String[] getArgTypes(String var1);

    protected String getArgumentList(String string) {
        String[] stringArray = this.getArgTypes(string);
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("p");
            stringBuffer.append(Integer.toString(i));
        }
        return stringBuffer.toString();
    }
}

