/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.completion.DefaultContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

final class SyntaxQueryHelper {
    public static final int COMPLETION_TYPE_UNKNOWN = 0;
    public static final int COMPLETION_TYPE_ATTRIBUTE = 1;
    public static final int COMPLETION_TYPE_VALUE = 2;
    public static final int COMPLETION_TYPE_ELEMENT = 3;
    public static final int COMPLETION_TYPE_ENTITY = 4;
    public static final int COMPLETION_TYPE_NOTATION = 5;
    public static final int COMPLETION_TYPE_DTD = 6;
    private TokenItem token = null;
    private String preText = "";
    private int erase = 0;
    private int tunedOffset = 0;
    private SyntaxElement element;
    private int completionType = 0;
    private boolean tokenBoundary;
    private DefaultContext ctx = new DefaultContext();

    public SyntaxQueryHelper(XMLSyntaxSupport xMLSyntaxSupport, int n) throws BadLocationException, IllegalStateException {
        this.tunedOffset = n;
        this.token = xMLSyntaxSupport.getPreviousToken(this.tunedOffset);
        if (this.token == null) {
            throw new BadLocationException("No token found at current position", n);
        }
        this.tokenBoundary = this.token.getOffset() + this.token.getImage().length() == this.tunedOffset;
        int n2 = this.token.getOffset();
        this.preText = "";
        this.erase = 0;
        int n3 = 0;
        int n4 = this.token.getTokenID().getNumericID();
        if (!this.tokenBoundary) {
            this.preText = this.token.getImage().substring(0, this.tunedOffset - this.token.getOffset());
            if ("".equals(this.preText)) {
                throw new IllegalStateException("Cannot get token prefix at " + this.tunedOffset);
            }
            if (xMLSyntaxSupport.lastTypedChar() != '<' && xMLSyntaxSupport.lastTypedChar() != '&') {
                switch (n4) {
                    case 4: 
                    case 5: 
                    case 11: {
                        int n5 = this.token.getImage().length();
                        int n6 = n5 - (this.tunedOffset - n2);
                        this.tunedOffset += n6;
                        n3 = n6;
                    }
                }
            }
        } else {
            switch (n4) {
                case 1: 
                case 4: 
                case 5: 
                case 11: 
                case 15: {
                    this.preText = this.token.getImage();
                }
            }
        }
        switch (n4) {
            case 4: {
                this.erase = this.preText.length() - 1 + n3;
                break;
            }
            case 11: {
                this.erase = this.preText.length() + -1 + n3;
                break;
            }
            case 5: {
                this.erase = this.preText.length() + n3;
                break;
            }
            case 7: {
                this.erase = this.preText.length();
                if (this.erase <= 0 || this.preText.charAt(0) != '\'' && this.preText.charAt(0) != '\"') break;
                --this.erase;
            }
        }
        this.element = xMLSyntaxSupport.getElementChain(this.tunedOffset);
        if (this.element == null) {
            throw new IllegalStateException("There exists a token therefore a syntax element must exist at " + n + ", too.");
        }
        this.completionType = this.element instanceof SyntaxNode && ((SyntaxNode)this.element).getNodeType() != 10 ? this.initContext() : 6;
    }

    private int initContext() {
        int n = this.token.getTokenID().getNumericID();
        SyntaxNode syntaxNode = (SyntaxNode)this.element;
        switch (n) {
            case 1: {
                if (this.preText.endsWith("<")) {
                    this.ctx.init(syntaxNode, "");
                    return 3;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 4: {
                if (StartTag.class.equals(syntaxNode.getClass()) || EmptyTag.class.equals(syntaxNode.getClass())) {
                    if (this.preText.equals("")) {
                        if (this.token.getImage().endsWith(">")) {
                            this.ctx.init(syntaxNode, this.preText);
                            return 2;
                        }
                        this.ctx.init(syntaxNode, this.preText);
                        return 3;
                    }
                    if (this.preText.endsWith("/>")) {
                        this.ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.endsWith(">")) {
                        this.ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.startsWith("</")) {
                        this.ctx.init(syntaxNode, this.preText.substring(2));
                        return 3;
                    }
                    if (!this.preText.startsWith("<")) break;
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 3;
                }
                if (EndTag.class.equals(syntaxNode.getClass()) && this.preText.startsWith("</")) {
                    this.ctx.init(syntaxNode, this.preText.substring(2));
                    return 3;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(">")) break;
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 7: {
                if (this.preText.endsWith("&")) {
                    this.ctx.init(syntaxNode, "");
                    return 4;
                }
                if ("".equals(this.preText)) {
                    String string = this.token.getImage();
                    char c = string.charAt(string.length() - 1);
                    if (c == '\'' || c == '\"') {
                        if (string.charAt(0) == c && string.length() > 1) {
                            return 0;
                        }
                        boolean bl = false;
                        for (TokenItem tokenItem = this.token.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
                            int n2 = tokenItem.getTokenID().getNumericID();
                            if (n2 == 7) {
                                bl = true;
                                break;
                            }
                            if (n2 != 11) break;
                        }
                        if (bl) break;
                        this.ctx.init(syntaxNode, this.preText);
                        return 2;
                    }
                    this.ctx.init(syntaxNode, this.preText);
                    return 2;
                }
                NamedNodeMap namedNodeMap = syntaxNode.getAttributes();
                int n3 = -1;
                AttrImpl attrImpl = null;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    AttrImpl attrImpl2 = (AttrImpl)namedNodeMap.item(i);
                    int n4 = attrImpl2.getFirstToken().getOffset();
                    if (n4 <= n3 || n4 >= this.token.getOffset()) continue;
                    n3 = n4;
                    attrImpl = attrImpl2;
                }
                if (this.preText.length() > 0) {
                    this.preText = this.preText.substring(1);
                }
                if (attrImpl != null) {
                    this.ctx.init(attrImpl, this.preText);
                } else {
                    this.ctx.init(syntaxNode, this.preText);
                }
                return 2;
            }
            case 6: {
                if (!"".equals(this.preText) || !"=".equals(this.token.getImage())) break;
                this.ctx.init(syntaxNode, "");
                return 2;
            }
            case 2: {
                if ((StartTag.class.equals(syntaxNode.getClass()) || EmptyTag.class.equals(syntaxNode.getClass())) && !this.token.getImage().startsWith("/")) {
                    this.ctx.init((Element)((Object)syntaxNode), "");
                    return 1;
                }
                return 0;
            }
            case 5: {
                if (!StartTag.class.equals(syntaxNode.getClass()) && !EmptyTag.class.equals(syntaxNode.getClass())) break;
                Tag tag = (Tag)syntaxNode;
                NamedNodeMap namedNodeMap = tag.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    AttrImpl attrImpl = (AttrImpl)namedNodeMap.item(i);
                    if (attrImpl.getFirstToken().getOffset() != this.token.getOffset()) continue;
                    this.ctx.init(attrImpl, this.preText);
                }
                if (!this.ctx.isInitialized()) {
                    this.ctx.init((Element)((Object)syntaxNode), this.preText);
                }
                return 1;
            }
            case 11: {
                if (this.preText.startsWith("&#")) {
                    return 0;
                }
                if (this.preText.endsWith(";")) {
                    this.ctx.init(syntaxNode, "");
                    return 2;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(";")) break;
                this.ctx.init(syntaxNode, this.preText);
                return 2;
            }
        }
        return 0;
    }

    public HintContext getContext() {
        if (this.completionType != 0 && this.completionType != 6) {
            return this.ctx;
        }
        return null;
    }

    public TokenItem getToken() {
        return this.token;
    }

    public String getPreText() {
        return this.preText;
    }

    public int getEraseCount() {
        return this.erase;
    }

    public int getOffset() {
        return this.tunedOffset;
    }

    public SyntaxElement getSyntaxElement() {
        return this.element;
    }

    public int getCompletionType() {
        return this.completionType;
    }

    public boolean isBoundary() {
        return this.tokenBoundary;
    }
}

