/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.callouts;

import com.jaspersoft.ireport.addons.ReportOpenedListener;
import com.jaspersoft.ireport.addons.callouts.CalloutWidget;
import com.jaspersoft.ireport.addons.callouts.CalloutsLayer;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;

public class CalloutsUtility {
    public static CalloutsLayer getCalloutsLayer(AbstractReportObjectScene scene, boolean create) {
        CalloutsLayer layer = null;
        for (Widget w : scene.getChildren()) {
            if (!(w instanceof CalloutsLayer)) continue;
            layer = (CalloutsLayer)w;
            break;
        }
        if (layer == null && create) {
            layer = new CalloutsLayer(scene);
            scene.addChild((Widget)layer);
            scene.validate();
        }
        return layer;
    }

    public static Widget createCalloutWidget(AbstractReportObjectScene abstractReportObjectScene) {
        CalloutWidget w = new CalloutWidget(abstractReportObjectScene);
        return w;
    }

    public static void saveCallouts(AbstractReportObjectScene scene) {
        JasperDesign jd = scene.getJasperDesign();
        CalloutsLayer layer = CalloutsUtility.getCalloutsLayer(scene, false);
        if (layer == null) {
            return;
        }
        Properties props = new Properties();
        List callouts = layer.getChildren();
        int i = 0;
        for (Widget w : callouts) {
            if (!(w instanceof CalloutWidget)) continue;
            ++i;
            CalloutWidget cw = (CalloutWidget)w;
            Rectangle bounds = w.getPreferredBounds();
            if (bounds == null) {
                bounds = w.getPreferredBounds();
            }
            if (bounds == null) continue;
            props.put("callouts." + i + ".bounds", w.getLocation().x + "," + w.getLocation().y + "," + bounds.width + "," + bounds.height);
            props.put("callouts." + i + ".text", cw.getText());
            String connectionsString = "";
            List connections = layer.getChildren();
            for (Widget conn : connections) {
                Widget pin;
                ConnectionWidget connW;
                if (!(conn instanceof ConnectionWidget) || (connW = (ConnectionWidget)conn).getSourceAnchor().getRelatedWidget() != cw || (pin = connW.getTargetAnchor().getRelatedWidget()) == null) continue;
                connectionsString = connectionsString + pin.getLocation().x + "," + pin.getLocation().y + ";";
            }
            if (connectionsString.length() <= 0) continue;
            props.put("callouts." + i + ".pins", connectionsString);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, "");
            String s = out.toString();
            s = Misc.string_replace((String)"", (String)"\r", (String)s);
            s = Misc.string_replace((String)"\\ncallouts.", (String)"\ncallouts.", (String)s);
            s = Misc.string_replace((String)"", (String)"\n", (String)s);
            jd.setProperty("ireport.callouts", s);
            ReportOpenedListener.getDefaultInstance().getViewForJasperDesign(jd).getEditorSupport().notifyModified();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void loadCallouts(AbstractReportObjectScene scene) {
        JasperDesign jd = scene.getJasperDesign();
        String s = jd.getProperty("ireport.callouts");
        s = Misc.string_replace((String)"\ncallouts.", (String)"\\ncallouts.", (String)s);
        CalloutsLayer layer = null;
        if (s != null) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(s.getBytes()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            int i = 1;
            while (props.containsKey("callouts." + i + ".text")) {
                String[] pinsDefs;
                String text = props.getProperty("callouts." + i + ".text");
                String bounds = props.getProperty("callouts." + i + ".bounds");
                String pins = props.getProperty("callouts." + i + ".pins");
                ++i;
                CalloutWidget w = new CalloutWidget(scene);
                w.setText(text);
                String[] vals = bounds.split(",");
                if (vals.length == 4) {
                    try {
                        w.setPreferredLocation(new Point(Integer.valueOf(vals[0].trim()), Integer.valueOf(vals[1].trim())));
                        Rectangle r = new Rectangle(0, 0, Integer.valueOf(vals[2].trim()), Integer.valueOf(vals[3].trim()));
                        w.setPreferredBounds(r);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (layer == null) {
                    layer = CalloutsUtility.getCalloutsLayer(scene, true);
                    layer.removeChildren();
                    scene.validate();
                }
                layer.addChild(w);
                scene.validate();
                if (pins == null) continue;
                for (String pinDef : pinsDefs = pins.split(";")) {
                    try {
                        String[] pinCoords = pinDef.split(",");
                        w.createPinConnection(new Point(Integer.valueOf(pinCoords[0].trim()), Integer.valueOf(pinCoords[1].trim())));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

