/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.TaskRetrieve;
import nickyb.sqleonardo.environment.ctrl.content.TaskUpdate;
import nickyb.sqleonardo.environment.ctrl.content.UpdateModel;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;

public class ContentPane
extends BorderLayoutPanel
implements ChangeListener {
    private JSlider sld;
    private JLabel status;
    private JTextArea syntax;
    private ContentView view;
    private Thread task;
    private String keycah;
    private QueryModel qmodel;
    private UpdateModel umodel;

    public ContentPane(String keycah, QueryModel qmodel, UpdateModel umodel) {
        super(2, 2);
        this.keycah = keycah;
        this.qmodel = qmodel;
        this.umodel = umodel;
        this.getActionMap().put("changes-save", new ActionSaveChanges());
        this.getActionMap().put("record-insert", new ActionInsertRecord());
        this.getActionMap().put("record-delete", new ActionDeleteRecord());
        this.getActionMap().put("task-stop", new ActionStopTask());
        this.getActionMap().put("task-go", new ActionRelaunch());
        this.sld = new JSlider(1);
        this.sld.addChangeListener(this);
        this.sld.setSnapToTicks(true);
        this.sld.setInverted(true);
        this.sld.setValue(0);
        this.sld.setMinimum(0);
        this.sld.setMaximum(0);
        this.status = new JLabel("...");
        this.status.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
        this.syntax = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.syntax);
        this.syntax.setRows(3);
        this.syntax.setText(qmodel.toString(false));
        this.syntax.setWrapStyleWord(true);
        this.syntax.setLineWrap(true);
        this.syntax.setEditable(false);
        this.syntax.setOpaque(false);
        BorderLayoutPanel pnlSouth = new BorderLayoutPanel(2, 2);
        pnlSouth.setComponentCenter(this.status);
        pnlSouth.setComponentNorth(scroll);
        this.setComponentWest(this.sld);
        this.setComponentSouth(pnlSouth);
        this.view = new ContentView(this);
        this.setComponentCenter(this.view);
    }

    public boolean isReadOnly() {
        return this.umodel == null;
    }

    public String getHandlerKey() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
        return this.keycah;
    }

    public QueryModel getQueryModel() {
        return this.qmodel;
    }

    public UpdateModel getUpdateModel() {
        return this.umodel;
    }

    public void setUpdateModel(UpdateModel model) {
        this.umodel = model;
    }

    public JSlider getSlider() {
        return this.sld;
    }

    public ContentView getView() {
        return this.view;
    }

    public boolean isBusy() {
        return this.task != null;
    }

    public void doStop() {
        this.onEndTask();
    }

    public void doRetrieve() {
        this.onBeginTask(new TaskRetrieve(this));
    }

    public void doRetrieve(int limit) {
        this.onBeginTask(new TaskRetrieve(this, limit));
    }

    public void doUpdate() {
        this.onBeginTask(new TaskUpdate(this));
    }

    private void onBeginTask(Runnable r) {
        this.setCursor(new Cursor(3));
        this.getActionMap().get("task-go").setEnabled(false);
        this.getActionMap().get("task-stop").setEnabled(true);
        this.getActionMap().get("changes-save").setEnabled(false);
        this.getActionMap().get("record-insert").setEnabled(false);
        this.getActionMap().get("record-delete").setEnabled(false);
        this.task = new Thread(r);
        this.task.start();
    }

    private void onEndTask() {
        this.task = null;
        this.getActionMap().get("task-go").setEnabled(true);
        this.getActionMap().get("task-stop").setEnabled(false);
        this.getActionMap().get("changes-save").setEnabled(true);
        this.getActionMap().get("record-insert").setEnabled(true);
        this.getActionMap().get("record-delete").setEnabled(true);
        this.setCursor(new Cursor(0));
    }

    public void doRefreshStatus() {
        this.sld.setMaximum(this.view.getBlockCount() == 0 ? 0 : this.view.getBlockCount() - 1);
        if (this.view.getRowCount() > 0) {
            this.status.setText("block " + this.view.getBlock() + " of " + this.view.getBlockCount() + " | record " + this.view.getLineAt(0) + " to " + this.view.getLineAt(this.view.getRowCount() - 1) + " of " + this.view.getFlatRowCount() + " | changes " + this.view.getChanges().count());
        } else {
            this.status.setText("0 records");
        }
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int block = source.getValue() + 1;
            if (this.view != null && block != this.view.getBlock()) {
                this.view.setBlock(block);
                this.doRefreshStatus();
            }
        }
    }

    private class ActionStopTask
    extends AbstractAction {
        ActionStopTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.011"));
        }

        public void actionPerformed(ActionEvent ae) {
            ContentPane.this.onEndTask();
        }
    }

    private class ActionRelaunch
    extends AbstractAction {
        ActionRelaunch() {
            this.putValue("Name", "relaunch query");
        }

        public void actionPerformed(ActionEvent ae) {
            if (!ContentPane.this.isBusy()) {
                ContentPane.this.syntax.setText(ContentPane.this.getQueryModel().toString(false));
                ContentPane.this.view.reset();
                ContentPane.this.doRetrieve();
            }
        }
    }

    private class ActionSaveChanges
    extends AbstractAction {
        ActionSaveChanges() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.162"));
            this.putValue("ShortDescription", "save changes");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ContentPane.this.getUpdateModel() != null && ContentPane.this.getUpdateModel().getRowIdentifierCount() > 0) {
                ContentPane.this.doUpdate();
            } else {
                Application.alert("SQLeonardo", "No update criteria defined!");
            }
        }
    }

    private class ActionDeleteRecord
    extends AbstractAction {
        ActionDeleteRecord() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.161"));
            this.putValue("ShortDescription", "delete record");
            this.putValue("Name", "delete record");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = ContentPane.this.view.getRow();
            int col = ContentPane.this.view.getColumn();
            if (row == -1) {
                return;
            }
            ContentPane.this.view.deleteRow(row);
            ContentPane.this.doRefreshStatus();
            if (ContentPane.this.view.getRowCount() == 0) {
                return;
            }
            if (row >= ContentPane.this.view.getRowCount()) {
                row = ContentPane.this.view.getRowCount() - 1;
            }
            ContentPane.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }

    private class ActionInsertRecord
    extends AbstractAction {
        ActionInsertRecord() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.160"));
            this.putValue("ShortDescription", "insert record");
            this.putValue("Name", "insert record");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = ContentPane.this.view.getRow();
            int col = ContentPane.this.view.getColumn();
            ContentPane.this.view.insertRow(++row);
            ContentPane.this.doRefreshStatus();
            if (row == ContentModel.MAX_BLOCK_RECORDS) {
                row = 0;
                ContentPane.this.sld.setValue(ContentPane.this.sld.getValue() + 1);
            }
            ContentPane.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }
}

