/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "seinfo.h"
#include "seinfo_process.h"

#include <iostream>
using namespace std;

Seinfo::Seinfo(QWidget *parent, const char *name): QDialog(parent, name)
{
        seinfoLabel = new QLabel(tr("Information on"),this);
        expressionLabel = new QLabel(tr("[=NAME|=TYPE|=ADDR|=PORT]"),this);

        expressionEditLineEdit = new QLineEdit( this );
        expressionEditLineEdit->setText("");
        expressionEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	seinfoButton = new QPushButton(tr("See seinfo"), this);
	seinfoButton->setPaletteBackgroundColor(QColor(200,80,50));
	connect(seinfoButton, SIGNAL(clicked()), this, SLOT(seinfo_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QHBoxLayout;
	leftLayout = new QVBoxLayout;
	rightLayout = new QVBoxLayout;

	leftLayout->addWidget(seinfoLabel);
	leftLayout->addWidget(createFirstExclusiveGroup());
	rightLayout->addWidget(createFirstExclusiveGroup2());
	rightLayout->addWidget(expressionLabel);
	rightLayout->addWidget(expressionEditLineEdit);
	rightLayout->addStretch(5);
	rightLayout->addWidget(seinfoButton);
	rightLayout->addStretch(1);
	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);

	setLayout(mainLayout);
	setWindowTitle(tr("Seinfo"));

	seinfo_process = 0;
}
QGroupBox *Seinfo::createFirstExclusiveGroup2()
{
        optionButtonGroupBox2 = new QGroupBox(tr("OPTIONS"));
        expandCheckBox = new QCheckBox(tr("expand(show more info for specified components)"));
        statsCheckBox = new QCheckBox(tr("stats(print useful policy statistics)"));
        helpCheckBox = new QCheckBox(tr("help(show help)"));
        versionCheckBox = new QCheckBox(tr("version(show version)"));

        expandCheckBox->setChecked(true);

	vbox2 = new QVBoxLayout;
        vbox2->addWidget(expandCheckBox);
        vbox2->addWidget(statsCheckBox);
        vbox2->addWidget(helpCheckBox);
        vbox2->addWidget(versionCheckBox);
	optionButtonGroupBox2->setLayout(vbox2);

	return optionButtonGroupBox2;
}

QGroupBox *Seinfo::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("EXPRESSIONS"));
	//second,declear many buttons  
        allRadioButton = new QRadioButton(tr("all(print all below)"));
        classRadioButton = new QRadioButton(tr("class[=NAME]"));
        sensitivityRadioButton = new QRadioButton(tr("sensitivity[=NAME]"));
        categoryRadioButton = new QRadioButton(tr("category[=NAME]"));
        typeRadioButton = new QRadioButton(tr("type[=NAME]"));
        attributeRadioButton = new QRadioButton(tr("attribute[=NAME]"));
        roleRadioButton = new QRadioButton(tr("role[=NAME]"));
        userRadioButton = new QRadioButton(tr("user[=NAME]"));
        boolRadioButton = new QRadioButton(tr("bool[=NAME]"));
        initialsidRadioButton = new QRadioButton(tr("initialsid[=NAME]"));
        fs_useRadioButton = new QRadioButton(tr("fs_use[=TYPE]"));
        genfsconRadioButton = new QRadioButton(tr("genfscon[=TYPE]"));
        netifconRadioButton = new QRadioButton(tr("netifcon[=NAME]"));
        nodeconRadioButton = new QRadioButton(tr("nodecon[=ADDR]"));
        portconRadioButton = new QRadioButton(tr("portcon[=PORT]"));
 	 //--protocol=PROTO                 specify a protocol for portcons

        allRadioButton->setChecked(true);

	//third,add widget to vboxlayout
	vbox = new QVBoxLayout;
        vbox->addWidget(allRadioButton);
        vbox->addWidget(classRadioButton);
        vbox->addWidget(sensitivityRadioButton);
        vbox->addWidget(categoryRadioButton);
        vbox->addWidget(typeRadioButton);
        vbox->addWidget(attributeRadioButton);
        vbox->addWidget(roleRadioButton);
        vbox->addWidget(userRadioButton);
        vbox->addWidget(boolRadioButton);
        vbox->addWidget(initialsidRadioButton);
        vbox->addWidget(fs_useRadioButton);
        vbox->addWidget(genfsconRadioButton);
        vbox->addWidget(netifconRadioButton);
        vbox->addWidget(nodeconRadioButton);
        vbox->addWidget(portconRadioButton);
	optionButtonGroupBox->setLayout(vbox);
	
	return optionButtonGroupBox;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Seinfo::seinfo_button_clicked()
{
	if(allRadioButton->isChecked())
		seinfo_str_pp = "seinfo --all";
	if(classRadioButton->isChecked())
		seinfo_str_pp = "seinfo --class";
	if(sensitivityRadioButton->isChecked())
		seinfo_str_pp = "seinfo --sensitivity";
	if(categoryRadioButton->isChecked())
		seinfo_str_pp = "seinfo --category";
	if(typeRadioButton->isChecked())
		seinfo_str_pp = "seinfo --type";
	if(attributeRadioButton->isChecked())
		seinfo_str_pp = "seinfo --attribute";
	if(roleRadioButton->isChecked())
		seinfo_str_pp = "seinfo --role";
	if(userRadioButton->isChecked())
		seinfo_str_pp = "seinfo --user";
	if(boolRadioButton->isChecked())
		seinfo_str_pp = "seinfo --bool";
	if(initialsidRadioButton->isChecked())
		seinfo_str_pp = "seinfo --initialsid";
	if(fs_useRadioButton->isChecked())
		seinfo_str_pp = "seinfo --fs_use";
	if(genfsconRadioButton->isChecked())
		seinfo_str_pp = "seinfo --genfscon";
	if(netifconRadioButton->isChecked())
		seinfo_str_pp = "seinfo --netifcon";
	if(nodeconRadioButton->isChecked())
		seinfo_str_pp = "seinfo --nodecon";
	if(portconRadioButton->isChecked())
		seinfo_str_pp = "seinfo --portcon";


	//set expression name or etc.
	expressionEditLineEdit_str = expressionEditLineEdit->text();
	if(expressionEditLineEdit_str != ""){
		seinfo_str_pp = seinfo_str_pp + expressionEditLineEdit_str;
	}

	if(expandCheckBox->isChecked())
		seinfo_str_pp = seinfo_str_pp + " --expand";
	if(statsCheckBox->isChecked())
		seinfo_str_pp = seinfo_str_pp + " --stats";
	if(helpCheckBox->isChecked())
		seinfo_str_pp = seinfo_str_pp + " --help";
	if(versionCheckBox->isChecked())
		seinfo_str_pp = seinfo_str_pp + " --version";

	seinfo_str_pp_str = seinfo_str_pp;

	seinfo_process = new SeinfoProcess(this);
	//connect(seinfo_process, SIGNAL(seinfo_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), seinfo_process, SLOT(close()));
	seinfo_process->setCaption(tr(seinfo_str_pp_str));
	seinfo_process->show();
	seinfo_process->raise();
	seinfo_process->setActiveWindow();

	seinfo_process->seinfo_base_process(seinfo_str_pp_str);

}
