package org.seasar.framework.exception;

import javax.transaction.SystemException;

import org.seasar.framework.message.MessageFormatter;

/**
 * @author higa
 *
 */
public class SSystemException extends SystemException {

	private String messageCode_;
	private Object[] args_;
	
	public SSystemException(String messageCode, Object[] args) {
		this(messageCode, args, null);
	}

	public SSystemException(String messageCode, Object[] args, Throwable cause) {
		super(MessageFormatter.getMessage(messageCode, args));
		messageCode_ = messageCode;
		args_ = args;
		this.initCause(cause);
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getArgs() {
		return args_;
	}
}
