package org.seasar.framework.exception;

import java.sql.SQLException;

import org.seasar.framework.message.MessageFormatter;

/**
 * @author higa
 *
 */
public class SSQLException extends SQLException {

	private String messageCode_;
	private Object[] args_;
	
	public SSQLException(String messageCode, Object[] args) {
		this(messageCode, args, null);
	}

	public SSQLException(String messageCode, Object[] args, Throwable cause) {
		super(MessageFormatter.getMessage(messageCode, args));
		messageCode_ = messageCode;
		args_ = args;
		this.initCause(cause);
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getArgs() {
		return args_;
	}
}
