/**
 * ************************************************************************
 * Moenizer - Allow to set background image for OmegaT.
 *
 * Copyright (C) 2014 Yu Tang Home page: http://sourceforge.jp/users/yu-tang/
 * Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/
 *
 * This file is part of plugin for OmegaT. http://www.omegat.org/
 *
 * License: GNU GPL version 3 or (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *************************************************************************
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect;

import java.lang.reflect.Constructor;
import java.util.Map;

/**
 * static method only
 *
 * @author Yu-Tang
 */
public class Effect {

    private Effect() {
        // prevent instantiation
    }

    public enum Type {
        BasicEffect
    }

    public static IEffect create(Type type, Map conf) throws Exception {
        final String CLASS_NAME = Effect.class.getPackage().getName() + "." + type.name();
        Class<? extends IEffect> clazz = (Class<? extends IEffect>) Class.forName(CLASS_NAME);
        Class<?>[] types = {Map.class};
        Constructor<? extends IEffect> constructor = clazz.getConstructor(types);
        Object[] args = {conf};
        IEffect newInstance = constructor.newInstance(args);
        return newInstance;
    }

}
