/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.imageloader.IImageLoader;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Log;

/**
 * allow to set background image
 * 
 * @author Yu-Tang
 */
public class Moenizer implements IApplicationEventListener {

    private static boolean instantiated = false;

    private IImageLoader imageLoader;
    private MoeUI ui;
    private MoeConfig config;
    private ThemeChanger themeChanger;

    public static void loadPlugins() {
        try {
            // Not initialize in console mode
            if (!instantiated) {
                CoreEvents.registerApplicationEventListener(new Moenizer());
                instantiated = true;
            } else {
                throw new RuntimeException("Moenizer plugin could be instantiated only once.");
            }
        } catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB(msg);
            Core.pluginLoadingError(msg);
        }
   }

    public static void unloadPlugins() {
        // do nothing
    }

    @Override
    public void onApplicationStartup() {
        try {
            config = new MoeConfig(MoeUtil.getMoeConfigFile());
            ui = MoeUI.getInstance();
            themeChanger = new ThemeChanger(ui);
            themeChanger.setTheme(config.getCurrentConfig());

            // この時点でコンポーネントの透過設定をしても反映されない（タイミング？）。
            // Workaround として、invokeLater でキューに突っ込んで、後で処理する。
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    CoreEvents.unregisterApplicationEventListener(Moenizer.this);
                    themeChanger.apply();
                }
            });
            //CoreEvents.unregisterApplicationEventListener(this); // ここで発行すると、スレッドエラーになるので注意
        } catch(Exception e) {
            Log.log("Error raised at " + this.getClass().getCanonicalName() + ".onApplicationStartup()\n" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void onApplicationShutdown() {
        // not used.
    }

    //@@TODO effect の具象クラスに移動
    private class SlideShow extends SwingWorker<Object, Void> {
        private long interval = -1;
        
        @Override
        protected Object doInBackground() throws Exception {
            while (imageLoader.availableNext()) {
                imageLoader.readyForNextImage();
                interval = interval < 0 ? 0 : imageLoader.getNextInterval();
                if (interval > 0) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(interval);
                    } catch (InterruptedException e) { /* ignore */ }
                }
                BufferedImage image = imageLoader.getNextImage();

                if (image != null) {
                    // 初期化直後に、まだ MoeUI がインスタンス化されていない
                    // 空白時間に遭遇する可能性があるため、その場合は 0.1 秒
                    // 単位で MoeUI のインスタンス化を待機する。
                    while (ui == null) {
                        TimeUnit.MILLISECONDS.sleep(100);
                    }
                    //ui.setBackground(image);
                }
            }
            return null;
        }
    }

}
