//! @file		pf_systick.h
//! @brief		プラットフォーム(SysTick)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_SYSTICK_H
#define PF_SYSTICK_H

#include "pf_types.h"

//! @brief		制御周期[ms]
#define PF_SYSTICK_SYNC_MS			((u4)5U)

//! @brief		SysTick時刻情報構造体
typedef struct PF_SYSTICK_TIME_Tag
{
	u4				sec;					//!< 秒(0～)
	u4				ms;						//!< ミリ秒(0～999)
	u4				us;						//!< マイクロ秒(0～999)
} PF_SYSTICK_TIME;

//! @brief		SysTick初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_systick_init(void);

//! @brief		次の制御周期まで待つ
//! @attention	グローバル割り込み禁止状態で呼び出さないこと
void pf_systick_sync(void);

//! @brief		SysTick時刻を取得
//! @param		[out] timebuf	SysTick時刻情報構造体へのポインタ
//! @attention	グローバル割り込み禁止状態で呼び出さないこと
void pf_systick_time(PF_SYSTICK_TIME *timebuf);

//! @brief		フリーランmsカウンタを取得
//! @return		フリーランmsカウンタ(32bit)
u4 pf_systick_freerun(void);

//! @brief		SysTick割り込みハンドラ
void SysTick_Handler(void);

#endif  // PF_SYSTICK_H
