// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

#pragma once

namespace UVTexIntegra {
	namespace CustomControls {

		ref class MainEditForm;
		struct UVNormalTransformedBuffer;

		//! @addtogroup UVTexIntegra-CustomControlsO
		//! @{

		//! @brief vO}u_FĂ݃RpCvr[p_CAO
		public ref class VertexColorCustomBakeForm : CustomBakeForm_Base, CustomControls::CompileResultForm::ICompileResultOwner {
		public:

			System::String^ OpenFileDialogDirectory;
			int OpenFileDialogScriptFilterIndex;
			property System::Drawing::Size CompileResultWindowSize {
				virtual System::Drawing::Size get() { return m_compileResultWindowSize; }
				virtual void set( System::Drawing::Size value ) { m_compileResultWindowSize = value; }
			}
			property TextLogForm^ Console { TextLogForm^ get(); }

			VertexColorCustomBakeForm(System::Drawing::Image^ background_image, System::Drawing::Color background_color,
				System::String^ serializedAssemblyCollection, IConfig^ config);
			~VertexColorCustomBakeForm() { this->!VertexColorCustomBakeForm(); }
			!VertexColorCustomBakeForm();

			System::String^ ToAssemblySerializedString();
			array<Scripting::LoadedAssembly::SerializeInformation^>^ ToSerializeInfoArray();

		protected:
			virtual void OnFormClosing(System::Windows::Forms::FormClosingEventArgs^ e) override;

		private:

			void UVBufferRebuild();
			void UVBufferPaintToGraphics(System::Drawing::Graphics^ graphics, System::Drawing::Size size);

			System::Void cmb_Reload();
			System::Void cmb_SelectedIndexChanged(Object^, System::EventArgs^);
			System::Void menuItemFile_DropDownClosed(Object^, System::EventArgs^);
			System::Void menuItemFile_DropDownOpened(Object^, System::EventArgs^);
			System::Void menuItemNewScript_Click(Object^, System::EventArgs^);
			System::Void menuItemSaveImage_Click(Object^, System::EventArgs^);
			System::Void menuItemScriptDelete_Click(Object^, System::EventArgs^);
			System::Void menuItemScriptFileOpen_Click(Object^, System::EventArgs^);
			System::Void menuItemScriptRebuild_Click(Object^, System::EventArgs^);
			System::Void pnlGL_GLLayout(System::Object^, System::EventArgs^);
			System::Void pnlGL_GLPaint(System::Object^, System::Windows::Forms::PaintEventArgs^);
			System::Void pnlGL_GLPrePaintOnce(System::Object^, System::ComponentModel::CancelEventArgs^);
			System::Void prop_ValueChanged(Object^, System::Windows::Forms::PropertyValueChangedEventArgs^);
			
			System::Object^ m_lock;
			System::Object^ m_drawLock;
			DotNetEx::CounterKey^ m_eventLock;

			System::Int32 m_glShaderProgram;

			System::Drawing::Size m_compileResultWindowSize;

			Scripting::AssemblyCollection^ m_assemblies;

			IConfig^ m_config;
			UVNormalTransformedBuffer* m_pUVBuffer;
			CustomControls::Drawing::FaceBuffer^ m_drawFaceBuffer;
		};
		
		//@}
	}
}
