﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.Scripting
{
    //! @addtogroup UVTexIntegra-Scripting名前空間
    //! @{

    public partial class ScriptMain
    {
        /// @cond <summary>面情報を取得/設定するための構造体を定義します。</summary> @endcond
        //! @brief 面情報を取得/設定するための構造体を定義します。
        public partial class Face : System.ICloneable
        {
            /// @cond <summary>面のIDを取得します。</summary> @endcond
            //! @brief 面のIDを取得します。
            //! @details 面のIDは、Face配列の中でFaceクラスのひとつひとつにユニークなIDが設定されます。
            public readonly System.UInt32 FaceID;

            /// @cond <summary>法線を取得します。三角ないしは四角形の面法線が取得されます。法線は正規化済みです。</summary> @endcond
            //! @brief 法線を取得します。三角ないしは四角形の面法線が取得されます。法線は正規化済みです。
            public readonly OpenTK.Vector3 Normal;

            /// @cond <summary>頂点ごとの情報を取得/設定します。</summary> @endcond
            //! @brief 頂点ごとの情報を取得/設定します。
            //! @details 面が三角形の時は３つ、四角形の時は４つの長さの配列を返します。
            public readonly Point[] Points;

            /// @cond <summary>無効（初期化されていない）かどうか判定します</summary> @endcond
            //! @brief 無効（初期化されていない）かどうか判定します
            public bool EmptyStatus { get { return Points == null; } }

            //! @brief　コンストラクタ
            //! @details @exception System.NullReferenceException pointsがnullです。
            public Face(System.UInt32 faceID, float nx, float ny, float nz, Point[] points)
            {
                FaceID = faceID;
                Normal = new OpenTK.Vector3(nx, ny, nz);
                Points = Point.Clone(points);
            }

            /// @cond <summary>コピーコンストラクタ(ディープコピー)</summary> @endcond
            //! @brief コピーコンストラクタ(ディープコピー)
            //! @details @exception System.NullReferenceException srcまたはsrc.Pointsがnullです。
            public Face(Face src)
            {
                FaceID = src.FaceID;
                Normal = src.Normal;
                Points = Point.Clone(src.Points);
            }

            /// @cond <summary>クローンメソッド</summary> @endcond
            //! @brief クローンメソッド
            public Face Clone() { return new Face(this); }

            /// @cond <summary>クローンメソッド（System.ICloneable）</summary> @endcond
            //! @brief クローンメソッド（System.ICloneable）
            object System.ICloneable.Clone() { return Clone(); }

            /// @cond <summary>クローンメソッド</summary> @endcond
            //! @brief クローンメソッド
            //! @return 全ての要素が個別にディープコピーされたクローン配列。srcがnullの時は空の配列が返ります。
            public static Face[] Clone(Face[] src)
            {
                if (src == null) return new Face[0];
                Face[] ret = new Face[src.LongLength];
                for (long index = 0; index < src.LongLength; index++) ret[index] = src[index].Clone();
                return ret;
            }
        }
    }
    //! @}
}
