﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU General Public License(GPL).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace UVTexIntegra.CustomControls
{
    public static partial class Drawing
    {
        public partial class Face
        {
            public struct Point
            {
                public readonly OpenTK.Vector2 Coordinate;
                public readonly System.Drawing.Color Color;

                //! @brief Scripting.ScriptMain.Face.Pointからのコピーコンストラクタ（ディープコピー）
                //! @details @exception System.NullReferenceException srcがnullです。
                public Point(Scripting.ScriptMain.Face.Point src)
                {
                    Coordinate = src.Coordinate;
                    Color = src.Color;
                }

                //! @brief 配列クローンメソッド(全ての要素をディープコピー)
                //! @return 全ての要素がディープクローンされた新しい配列。srcがnullの時は空の配列が返ります。
                //! @details @exception System.NullReferenceException srcの中の要素にnullがあります。
                public static Point[] Clone(Scripting.ScriptMain.Face.Point[] src)
                {
                    if (src == null) return new Point[0];
                    Point[] ret = new Point[src.LongLength];
                    for (long index = 0; index < src.LongLength; index++) ret[index] = new Point(src[index]);
                    return ret;
                }
            }
        }
    }
}
