package mirrg.swing.helium.v1_0;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;

import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent.EventType;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;

import mirrg.struct.hydrogen.v1_0.Struct1;
import mirrg.struct.hydrogen.v1_0.Tuple;
import mirrg.swing.helium.v1_0.logging.EnumTypeLog;
import mirrg.swing.helium.v1_0.logging.HLog;

public class FrameHTML extends FrameMirrg {

	/**
	 * 下に行くほど新しい。
	 */
	private LinkedList<Tuple<URL, Integer>> historyLeft = new LinkedList<>();
	/**
	 * 下に行くほど新しい。
	 */
	private LinkedList<Tuple<URL, Integer>> historyRight = new LinkedList<>();

	private JButton button1;
	private JButton button2;
	private JTextField textField1;
	private JEditorPane editorPane1;
	private JScrollPane scrollPane1;

	public FrameHTML() {
		setTitle("HTMLビューワ");

		{

			button1 = new JButton("戻る");
			button1.setToolTipText("右クリック：プルダウンメニューの表示");
			button1.addActionListener(e -> {
				if (!historyLeft.isEmpty())
					travelLeft(1);
			});
			HSwing.hookPopup(button1, e -> {

				if (!historyLeft.isEmpty()) {
					JPopupMenu popupMenu = new JPopupMenu();

					for (int i = historyLeft.size() - 1; i >= 0; i--) {
						Tuple<URL, Integer> entry = historyLeft.get(i);
						JMenuItem menuItem = new JMenuItem(entry.getY()
								.toString() + ": " + entry.getX().toString());
						popupMenu.add(menuItem);

						int i2 = i + 1;
						menuItem.addActionListener(e2 -> {
							travelLeft(i2);
						});
					}

					popupMenu.show((Component) e.getSource(), e.getX(),
							e.getY());

					return true;
				}

				return false;
			});

			button2 = new JButton("進む");
			button2.setToolTipText("右クリック：プルダウンメニューの表示");
			button2.addActionListener(e -> {
				if (!historyRight.isEmpty())
					travelRight(1);
			});
			HSwing.hookPopup(button2, e -> {

				if (!historyRight.isEmpty()) {
					JPopupMenu popupMenu = new JPopupMenu();

					for (int i = 0; i < historyRight.size(); i++) {
						Tuple<URL, Integer> entry = historyRight.get(i);
						JMenuItem menuItem = new JMenuItem(entry.getY()
								.toString() + ": " + entry.getX().toString());
						popupMenu.add(menuItem);

						int i2 = i + 1;
						menuItem.addActionListener(e2 -> {
							travelRight(i2);
						});
					}

					popupMenu.show((Component) e.getSource(), e.getX(),
							e.getY());

					return true;
				}

				return false;
			});

			textField1 = new JTextField();
			textField1.addActionListener(e -> {
				navigate(textField1.getText());
			});

			JButton button3 = new JButton("移動");
			button3.addActionListener(e -> {
				navigate(textField1.getText());
			});

			JButton button4 = new JButton("更新");
			button4.addActionListener(e -> {
				refresh();
			});

			editorPane1 = new JEditorPane();
			editorPane1.setEditable(false);
			editorPane1.addHyperlinkListener(e -> {
				if (e.getEventType() == EventType.ACTIVATED) {
					navigate(e.getURL());
				}
			});
			editorPane1.addKeyListener(new KeyListener() {

				@Override
				public void keyTyped(KeyEvent e) {

				}

				@Override
				public void keyReleased(KeyEvent e) {

				}

				@Override
				public void keyPressed(KeyEvent e) {
					if (e.getKeyCode() == KeyEvent.VK_F5) {
						refresh();
						return;
					}
					if (e.getKeyCode() == KeyEvent.VK_BACK_SPACE) {
						if (!historyLeft.isEmpty())
							travelLeft(1);
						return;
					}
				}

			});

			scrollPane1 = new JScrollPane(editorPane1);
			scrollPane1.setPreferredSize(new Dimension(800, 800));

			{
				GroupLayout layout = new GroupLayout(getContentPane());
				setLayout(layout);

				layout.setAutoCreateGaps(true);
				layout.setAutoCreateContainerGaps(false);

				GroupBuilder.group(
						GroupBuilder.group(button1, button2,
								new JLabel("アドレス:"), textField1, button3,
								button4).align(Alignment.CENTER), scrollPane1)
						.apply(layout);
			}
		}

		historyChanged();

		HLog.log(EnumTypeLog.FINE, "HTMLビューワを起動しました");

		prepareFrame();
	}

	private void refresh() {
		Tuple<URL, Integer> now = getNow();

		((HTMLDocument) editorPane1.getDocument()).getDocumentProperties()
				.remove(Document.StreamDescriptionProperty);

		if (now != null)
			setPage(now);
	}

	private Tuple<URL, Integer> getNow() {
		URL page = editorPane1.getPage();

		return page == null ? null : new Tuple<>(page, scrollPane1
				.getVerticalScrollBar().getValue());
	}

	private void travelLeft(int times) {
		Tuple<URL, Integer> now = getNow();

		// 履歴操作
		for (int i = 0; i < times; i++) {
			historyRight.addFirst(now);
			now = historyLeft.removeLast();
		}

		historyChanged();

		setPage(now);
	}

	private void travelRight(int times) {
		Tuple<URL, Integer> now = getNow();

		// 履歴操作
		for (int i = 0; i < times; i++) {
			historyLeft.addLast(now);
			now = historyRight.removeFirst();
		}

		historyChanged();

		setPage(now);
	}

	private void setPage(Tuple<URL, Integer> url) {
		try {
			editorPane1.setPage(url.getX());
		} catch (IOException e) {
			HLog.processExceptionWarning(e);
			return;
		}

		textField1.setText(url.getX().toString());

		// 表示位置調整
		Struct1<PropertyChangeListener> listener = new Struct1<>();
		listener.x = e -> {
			editorPane1.removePropertyChangeListener("page", listener.x);

			scrollPane1.getVerticalScrollBar().setValue(url.getY());

		};
		editorPane1.addPropertyChangeListener("page", listener.x);

		// 同じページに遷移した場合にイベントが発生しないので念のために変更しておく
		// TODO イベントが残留するが次のイベントで死ぬのでとりあえず良しとする
		scrollPane1.getVerticalScrollBar().setValue(url.getY());

	}

	public void navigate(String url) {
		Tuple<URL, Integer> now = getNow();
		if (now != null) {
			historyLeft.addLast(now);
			historyChanged();
		}

		try {
			editorPane1.setPage(url);
		} catch (IOException e) {
			HLog.processExceptionWarning(e);
			return;
		}

		textField1.setText(url);
	}

	public void navigate(URL url) {
		Tuple<URL, Integer> now = getNow();
		if (now != null) {
			historyLeft.addLast(now);
			historyChanged();
		}

		try {
			editorPane1.setPage(url);
		} catch (IOException e) {
			HLog.processExceptionWarning(e);
			return;
		}

		textField1.setText(url.toString());
	}

	private void historyChanged() {
		button1.setEnabled(!historyLeft.isEmpty());
		button2.setEnabled(!historyRight.isEmpty());
	}

}
