﻿using UnityEngine;
using System.Collections;

public class Cube : MonoBehaviour {

	const float MOVE_DECAY = 0.5f;
	private GameObject _player = null;

	// Use this for initialization
	void Start () {
		MeshFilter mf = GetComponent<MeshFilter>();
		mf.mesh.SetIndices(mf.mesh.GetIndices(0),MeshTopology.LineStrip,0);

		MeshRenderer mr = GetComponent<MeshRenderer>();
		mr.material.color = new Color(0.4f, 0.4f, 0.9f);
	}

	private void MoveToPlayer() {
		if(_player == null) {
			_player = GameObject.FindWithTag ("Player");
		}
		Vector2 p1 = transform.position;
		Vector2 p2 = _player.transform.position;
		float dx = p2.x - p1.x;
		float dy = p2.y - p1.y;

		Vector2 pos = transform.position;
		pos.x += dx * MOVE_DECAY;
		pos.y += dy * MOVE_DECAY;
		transform.position = pos;
	}

	// Update is called once per frame
	void Update () {
		float v = Time.deltaTime * 50;
		transform.Rotate (v, v*0.7f, 0);

		MoveToPlayer();
	}

	void OnTriggerEnter2D(Collider2D c) {
		Destroy (c.gameObject);
	}
}
