﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

class CSV {
	private string[] _header;
	private string[] _types;
	private Dictionary<int, Dictionary<string, string>> _datas;

	public CSV(string text) {
		_datas = new Dictionary<int, Dictionary<string, string>>();
		var row = 0;
		foreach(var line in text.Split('\n')) {
			if(line == "") { break; }
			switch(row) {
			case 0:
				// header.
				_header = line.Split(',');
				break;
			case 1:
				// types.
				_types = line.Split(',');
				break;
			default:
				// datas.
				var datas = line.Split(',');
				var data = new Dictionary<string, string>();
				int key = 0;
				var i = 0;
				foreach(var d in datas) {
					var h = _header[i];
					if(h == "id") {
						key = int.Parse(d);
					}
					data[h] = d;
					i++;
				}
				_datas[key] = data;
				break;
			}
			row++;
		}
	}

	public void Dump() {
		string tmp = "";
		foreach(var s in _header) {
			tmp += s + ", ";
		}
		Debug.Log(tmp);

		tmp = "";
		foreach(var s in _types) {
			tmp += s + ", ";
		}
		Debug.Log(tmp);

		foreach(KeyValuePair<int, Dictionary<string, string>> pair in _datas) {
			tmp = pair.Key + ":";
			foreach(var s in pair.Value) {
				tmp += s + ", ";
			}
			Debug.Log(tmp);
		}
	}
}

public class CSVLoader : MonoBehaviour {

	// Use this for initialization
	void Start () {
	
		var txt = Resources.Load ("CSVs/table") as TextAsset;
		var csv = new CSV(txt.text);
		csv.Dump();

	}
	
	// Update is called once per frame
	void Update () {
	
	}
}
