#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame

class Joystick:
	""" ジョイスティッククラス """
	def __init__(self, id=0):
		self.joystick = pygame.joystick.Joystick(id)
		self.joystick.init()
		self.nButton = self.joystick.get_numbuttons()
	def getAxisX(self):
		return self.joystick.get_axis(0)
	def getAxisY(self):
		return self.joystick.get_axis(1)
	def getButtonList(self):
		return map(
			lambda n: self.joystick.get_button(n),
			range(self.nButton))
	def getButton(self, n):
		return self.joystick.get_button(n)
