package framework;

import framework.util.Debug;
import framework.Token;

/**
 * トークン管理
 * @author syun
 */
class TokenManager {
    /**
     * 管理する要素
     */
    private var m_Pool:Array<Token>;
    /**
     * コンストラクタ
     */
    public function new(type:Class<Token>, size:Int) {
        m_Pool = new Array<Token>();
        for (i in 0...size) {
            var t = Type.createInstance(type, []);
            m_Pool.push(t);
        }
    }
    /**
     * 要素の追加
     * @param	x
     * @param	y
     * @param	deg
     * @param	speed
     * @param	ax
     * @param	ay
     * @return
     */
    public function add(x:Float, y:Float, deg:Float=0, speed:Float=0, ax:Float=0, ay:Float=0):Token {
        for(s in m_Pool) {
            if (s.exist) { continue; }
            s.create(x, y, deg, speed, ax, ay);
            return s;
        }
        return null;
    }

    /**
     * トークンの生存数を返す
     * @return 生存数
     */
    public function count():Int {
        var ret:Int = 0;
        for(t in m_Pool) {
            if (t.exist == false) { continue; }
            ret++;
        }
        return ret;
    }
    /**
     * 管理しているToken配列を返す
     * @return Token配列
     */
    public function getArray():Array<Token> {
        return m_Pool;
    }

    /**
     * 消滅
     */
    public function vanish():Void {
        for(t in m_Pool) {
            t.exist = false;
        }
    }
    /**
     * 更新
     */
    public function update():Void {
        //for each(var t:Token in m_Pool)
        for(t in m_Pool) {
            if (t.exist == false) { continue; }
            t.update();
        }
    }
    /**
     * 描画
     */
    public function draw():Void {
        for(t in m_Pool) {
            if (t.exist == false) { continue; }
            t.draw();
        }

        if (Debug.isDrawHit) {
            for(t in m_Pool) {
                if (t.exist == false) { continue; }
                t.drawHit();
            }
        }

    }
}

