package framework;

import framework.util.HitRect;
import framework.IToken;
import framework.util.Maths;
/**
 * ゲームトークン
 * @author syun
 */
class Token extends IToken
{
    public var exist:Bool = false;
    public var x:Float = 0;
    public var y:Float = 0;
    public var vx:Float = 0;
    public var vy:Float = 0;
    public var ax:Float = 0;
    public var ay:Float = 0;
    public var deg:Float = 0;
    public var speed:Float = 0;
    public var hitRects:Array<HitRect>;

    /**
     * コンストラクタ
     **/
    public function new() {
        super();
    }

    /**
     * 生成
     * @param	x
     * @param	y
     * @param	deg
     * @param	speed
     * @param	ax
     * @param	ay
     */
    public function create(x:Float, y:Float, deg:Float = 0, speed:Float = 0, ax:Float = 0, ay:Float = 0):Void
    {
        this.deg = deg;
        this.speed = speed;
        var dx:Float = Maths.cosEx(deg) * speed;
        var dy:Float = -Maths.sinEx(deg) * speed;
        create2(x, y, dx, dy, ax, ay);
    }
    /**
     * 生成
     * @param	x
     * @param	y
     * @param	vx
     * @param	vy
     * @param	ax
     * @param	ay
     */
    public function create2(x:Float, y:Float, vx:Float = 0, vy:Float = 0, ax:Float = 0, ay:Float = 0):Void
    {
        exist = true;
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.ax = ax;
        this.ay = ay;
    }

    /**
     * 消滅
     */
    public function vanish():Void
    {
        exist = false;
    }

    /**
     * 画面外に出たかどうか
     * @param	w 幅
     * @param	h 高さ
     * @return 画面外に出たら「true」
     */
    public function isOut(w:Float=0, h:Float=0):Bool
    {
        if (x < -w) { return true; }
        if (x - w > Main.WIDTH) { return true; }
        if (y < -h) { return true; }
        if (y - h > Main.HEIGHT) { return true; }
        return false;
    }

    /**
     * 狙い撃ちの角度を取得する
     * @param	x
     * @param	y
     * @return
     */
    public function getAim(x:Float, y:Float):Float
    {
        var dx:Float = this.x - x;
        var dy:Float = this.y - y;
        return Maths.atan2Ex(dx, dy);
    }

    /**
     * 移動する
     */
    public function move():Void
    {
        vx += ax;
        vy += ay;
        x += vx;
        y += vy;
    }

    /**
     * ヒットチェック
     * @param	target 当たり判定の対象
     * @param	alterHitRects
     * @return ヒットしていた「true」
     */
    public function isHit(target:Token, alterHitRects:Array<HitRect> = null):Bool {
        var hr:Array<HitRect> = if(alterHitRects == null) hitRects else alterHitRects;
        if (target == null || hr == null || target.hitRects == null) {
            return false;
        }

        for(h in hr) {
            var hx:Float = x + h.x - h.w/2;
            var hy:Float = y + h.y - h.h/2;
            var hx2:Float = x + h.x + h.w/2;
            var hy2:Float = y + h.y + h.h/2;

            for(t in target.hitRects) {
                var tx:Float = target.x + t.x - t.w/2;
                var ty:Float = target.y + t.y - t.h/2;
                var tx2:Float = target.x + t.x + t.w/2;
                var ty2:Float = target.y + t.y + t.h/2;

                if (hx < tx2 && hx2 > tx && hy < ty2 && hy2 > ty) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 当たり判定の描画を行う
     * @param	bg
     */
    public function drawHit():Void {
        if(hitRects == null) { return; }

        for(r in hitRects) {
            r.draw(x, y);
        }
    }

}

