package framework;

import flash.errors.Error;
import flash.media.SoundChannel;
import openfl.Assets;
import flash.media.SoundChannel;
import flash.media.Sound;

class SoundManager {
    private static inline var ROOT_PATH = "assets/";

    private var m_Bgm:SoundChannel;
    private var m_PoolSe:Map<String, Sound>;
    private var m_Channels:Map<String, SoundChannel>;
    private var m_bBgm:Bool;
    private var m_bSe:Bool;

    public function new() {
        m_Bgm = null;
        m_PoolSe = new Map<String, Sound>();
        m_Channels = new Map<String, SoundChannel>();

        m_bBgm = true;
        m_bSe = true;
    }

    public function SetEnableBgm(b:Bool): Void {
        m_bBgm = b;

        if(m_bBgm == false) {
            stop();
        }

    }
    public function SetEnableSe(b:Bool): Void {
        m_bSe = b;
    }

    /**
     * SEのロード
     * @param name キーとなる名前
     * @param path ファイルパス
     **/
    public function load(name:String, path:String): Void {
        var snd = Assets.getSound(ROOT_PATH+path);
        if(snd == null) {
            throw new Error("Error: File not found. " + path);
        }
        m_PoolSe.set(name, snd);
    }

    /**
     * SEを再生。あらかじめ load() で読み込んでおく
     * @param key load()で指定したキー
     **/
    public function play(key:String): Void {

        if(m_bSe == false) {
            // SE無効
            return;
        }

        var snd:Sound = m_PoolSe.get(key);
        if(m_Channels.exists(key)) {
            var ch:SoundChannel = m_Channels.get(key);
            ch.stop();
            m_Channels.remove(key);
        }
        var ch2:SoundChannel = snd.play();
        m_Channels.set(key, ch2);
    }

    /**
     * BGMを再生する
     * @param path ファイルパス
     **/
    public function loop(path:String) {

        if(m_bBgm == false) {
            // BGM無効
            return;
        }

        stop();
        var snd:Sound = Assets.getMusic(ROOT_PATH+path);
        if(snd == null) {
            throw new Error("Error: File not found. " + path);
        }
        m_Bgm = snd.play(0, 2147483647);
    }

    /**
     * BGMを停止する
     **/
    public function stop() {
        if(m_Bgm != null) {
            m_Bgm.stop();
        }
        m_Bgm = null;
    }
}
