package framework;

import framework.Mouse;
import framework.Keyboard;

/**
 * ゲームパッドの入力管理
 * @author syun
 */
class GamePad
{
    private var m_Mouse:Mouse;
    private var m_Keyboard:Keyboard;

    public function new() {
    }

    public function setMouse(m:Mouse):Void {
        m_Mouse = m;
    }
    public function setKeyboard(k:Keyboard):Void {
        m_Keyboard = k;
    }

    public function isOn(index:Int):Bool {
        if (m_Keyboard.isOn(index)) { return true; }
        if (index == 0 && m_Mouse.isOn()) { return true; }
        return false;
    }

    public function isPress(index:Int):Bool {
        if (m_Keyboard.isPress(index) == true) { return true; }
        if (index == 0 && m_Mouse.isPress()) { return true; }

        return false;
    }

    public function isOnLeft():Bool { return m_Keyboard.isOnArrow(Keyboard.ARROW_LEFT); }
    public function isOnUp():Bool { return m_Keyboard.isOnArrow(Keyboard.ARROW_UP); }
    public function isOnRight():Bool { return m_Keyboard.isOnArrow(Keyboard.ARROW_RIGHT); }
    public function isOnDown():Bool { return m_Keyboard.isOnArrow(Keyboard.ARROW_DOWN); }

    public function isPressLeft():Bool { return m_Keyboard.isPressArrow(Keyboard.ARROW_LEFT); }
    public function isPressUp():Bool { return m_Keyboard.isPressArrow(Keyboard.ARROW_UP); }
    public function isPressRight():Bool { return m_Keyboard.isPressArrow(Keyboard.ARROW_RIGHT); }
    public function isPressDown():Bool { return m_Keyboard.isPressArrow(Keyboard.ARROW_DOWN); }

    public function getX():Int {
        return m_Keyboard.getX();
    }

    public function getY():Int {
        return m_Keyboard.getY();
    }

    public function x():Int {
        return m_Mouse.x();
    }
    public function y():Int {
        return m_Mouse.y();
    }

    public function isOnKey(key:String):Bool { return m_Keyboard.isOnKey(key); }
    public function isPressKey(key:String):Bool { return m_Keyboard.isPressKey(key); }
}
