package framework;

import flash.display.Bitmap;
import framework.GraphicManager;

/**
 * ...
 * @author syun
 */
class FontManager
{
    // 定数
    private static inline var decoder:String
        = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.()[]#$%&'\"!?^+-*/=;:_<>|\\";
    public static inline var WIDTH:Int = 16; // フォントの幅
    public static inline var HEIGHT:Int = 16; // フォントの高さ
    private static inline var COLUMN:Int = 16; // フォントテクスチャの一行の文字数
    private static inline var _ASCII:String = "__FONT";
    private var _g:GraphicManager;

    /**
     * コンストラクタ
     */
    public function new(g:GraphicManager) {
        _g = g;
    }
    /**
     * リソースロード
     */
    public function load():Void {
        _g.loadEx(_ASCII, "assets/system/font.png");
    }

    /**
     * Asciiフォントの描画
     * @param	x 描画座標(X)
     * @param	y 描画座標(Y)
     * @param	str 描画文字列
     * @param	scale 拡大縮小サイズ
     */
    public function drawAscii(x:Float, y:Float, str:String, scale:Float=1):Void {
        var px = x;
        for (i in 0...str.length)
        {
            var c:String = str.charAt(i);
            if (c == "\n")
            {
                px = x;
                y += HEIGHT;
                continue;
            }
            var idx:Int = decoder.indexOf(c);
            if (idx >= 0) {
                var ox:Int = (idx % COLUMN) * WIDTH;
                var oy:Int = Math.floor(idx / COLUMN) * HEIGHT;
                _g.draw2(_g.get(_ASCII), px, y, ox, oy, WIDTH, HEIGHT, scale, scale);
            }
            px += WIDTH * scale;
        }
    }
    public function drawAsciiEx(str:String, cx:Float, cy:Float, scale:Int = 1):Void {
        var x = cx - str.length * WIDTH / 2 * scale;
        var y = cy - HEIGHT / 2 * scale;
        drawAscii(x, y, str, scale);
    }
}

