// 
//  BSThreadInformationObject.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 10/10/12.
//  Copyright 2010 masakih. All rights reserved.
//

#import "BSThreadInformationObject.h"

#import "BSBoardInformationObject.h"
#import "BSThreadListItemObject.h"

//#import "CMRDocumentFileManager.h"

@implementation BSThreadInformationObject 

@dynamic threadLabel;
@dynamic threadID;
@dynamic numberOfRead;
@dynamic numberOfDifference;
@dynamic lastWrittenDate;
@dynamic isDatOchi;
@dynamic threadName;
@dynamic numberOfAll;
@dynamic modifiedDate;
@dynamic isNew;
@dynamic threadStatus;
@dynamic threadAboneType;
@dynamic isHeadModified;
@dynamic creationDate;
@dynamic threadListItems;
@dynamic board;


+ (NSSet *)keyPathsForValuesAffectingNumberOfDifference
{
	return [NSSet setWithObjects:@"numberOfRead", @"numberOfAll", nil];
}
+ (NSSet *)keyPathsForValuesAffectingCreationDate
{
	return [NSSet setWithObjects:@"threadID", nil];
}
+ (NSSet *)keyPathsForValuesAffectingIsDatOchi
{
	return [NSSet setWithObjects:@"threadStatus", nil];
}
+ (NSSet *)keyPathsForValuesAffectingIsNew
{
	return [NSSet setWithObjects:@"threadStatus", nil];
}

- (NSString *)identifier
{
	return self.threadID;
}

- (NSNumber *)threadstatus
{
	return self.threadStatus;
}
- (NSNumber *)threadnumber
{
	return nil;
}
- (NSString *)threadname
{
	return self.threadName;
}
- (NSDate *)lastwrittendate
{
	return self.lastWrittenDate;
}
- (NSDate *)modifieddate
{
	return self.modifiedDate;
}
- (NSNumber *)numberofall
{
	return self.numberOfAll;
}
- (NSNumber *)numberofread
{
	return self.numberOfRead;
}
- (NSNumber *)numberofdifference
{
	return self.numberOfDifference;
}
//- (NSNumber *)ikioi
//{
//	return [self valueForKey:BSThreadEnergyKey];
//}
- (NSString *)boardname
{
	return self.board.boardName;
}
- (NSString *)threadid
{
	return self.threadID;
}
- (NSNumber *)threadlabel
{
	return self.threadLabel;
}

- (NSString *)boardName
{
	return self.board.boardName;
}


- (NSNumber *)numberOfDifference
{
	NSNumber *all = self.numberOfAll;
	NSNumber *read = self.numberOfRead;
	if(!all || !read) return nil;
	if(all == (id)[NSNull null] || read == (id)[NSNull null]) return (id)[NSNull null];
	
	return [NSNumber numberWithInteger:[self.numberOfAll integerValue] - [self.numberOfRead integerValue]];
}
- (void)setThreadID:(NSString *)value
{
	[self willChangeValueForKey:@"threadID"];
	[self setPrimitiveValue:value forKey:@"threadID"];
	[self didChangeValueForKey:@"threadID"];
	
	NSTimeInterval threadIDNumber = [self.threadID doubleValue];
	NSDate *aDate = [NSDate dateWithTimeIntervalSince1970:threadIDNumber];
	
	self.creationDate = aDate;
}
- (void)setNumberOfAll:(NSNumber *)value
{
	[self willChangeValueForKey:@"numberOfAll"];
	[self setPrimitiveValue:value forKey:@"numberOfAll"];
	[self didChangeValueForKey:@"numberOfAll"];
	
//	[self updateStatus];
}
- (void)setNumberOfRead:(NSNumber *)value
{
	[self willChangeValueForKey:@"numberOfRead"];
	[self setPrimitiveValue:value forKey:@"numberOfRead"];
	[self didChangeValueForKey:@"numberOfRead"];
	
//	[self updateStatus];
}

- (NSUInteger)label
{
	return [self.threadLabel unsignedIntegerValue];
}
- (BOOL)datOchi
{
	return [self.isDatOchi boolValue];
}
- (NSUInteger)status
{
	return [self.threadStatus unsignedIntegerValue];
}

- (NSNumber *)threadNumber
{
	return nil;
}
//- (id)valueForUndefinedKey:(NSString *)key
//{
//	if([key isEqualToString:CMRThreadTitleKey]) {
//		return self.threadName;
//	}
//	if([key isEqualToString:CMRThreadNumberOfMessagesKey]) {
//		return self.numberOfAll;
//	}
//	if([key isEqualToString:CMRThreadLastLoadedNumberKey]) {
//		return self.numberOfRead;
//	}
//	if([key isEqualToString:CMRThreadNumberOfUpdatedKey]) {
//		return self.numberOfDifference;
//	}
//	if([key isEqualToString:ThreadPlistIdentifierKey]) {
//		return self.creationDate;
//	}
//	if([key isEqualToString:@"LastWrittenDate"]) {
//		return self.lastWrittenDate;
//	}
//	
//	if([key isEqualToString:BSThreadEnergyKey]) {
//		NSInteger res = [self.numberOfAll integerValue];
//		CGFloat createDateTime = [self.creationDate timeIntervalSince1970];
//		
//		CGFloat currentDateTime = [[NSDate dateWithTimeIntervalSinceNow:0.0] timeIntervalSince1970];
//		
//		CGFloat deltaTime = currentDateTime - createDateTime;
//		if(deltaTime == 0) return nil;
//		
//		CGFloat ikioi = (res * 60 * 60 * 24) / deltaTime;
//		
//		return [NSNumber numberWithDouble:ikioi];
//	}
//	
//	if([key isEqualToString:ThreadPlistBoardNameKey]) {
//		return self.board.boardName;
//	}
//	
//	
//	return [super valueForUndefinedKey:key];
//}


//- (NSString *)threadFilePath
//{
//	return [[CMRDocumentFileManager defaultManager] threadPathWithBoardName:self.board.boardName
//															  datIdentifier:self.threadID];
//}
//- (NSDictionary *)attribute
//{
//	NSMutableDictionary *result = [NSMutableDictionary dictionaryWithCapacity:7];
//	
//	[result setValue:self.threadName forKey:CMRThreadTitleKey];
//	[result setValue:[self.numberOfAll stringValue] forKey:CMRThreadNumberOfMessagesKey];
//	[result setValue:self.threadID forKey:ThreadPlistIdentifierKey];
//	[result setValue:self.board.boardName forKey:ThreadPlistBoardNameKey];
//    [result setValue:self.threadStatus forKey:CMRThreadStatusKey];
//	[result setValue:self.modifiedDate forKey:CMRThreadModifiedDateKey];
//	[result setValue:[self threadFilePath] forKey:CMRThreadLogFilepathKey];
//	
//	return result;
//}

//- (void)updateStatus
//{
////	NSLog(@"%s: Why did not update automatic?", __PRETTY_FUNCTION__);
//	
//	NSNumber *diff = self.numberOfDifference;
//	if(!diff || diff == (id)[NSNull null]) {
//		self.threadStatus = [NSNumber numberWithInteger:ThreadNoCacheStatus];
//		return;
//	}
//	
//	NSInteger diffValue = [diff integerValue];
//	if(0 == diffValue) {
//		self.threadStatus = [NSNumber numberWithInteger:ThreadLogCachedStatus];
//	} else {
//		self.threadStatus = [NSNumber numberWithInteger:ThreadUpdatedStatus];
//	}
//}

@end
