//
//  BSDCAppDelegate.m
//  BathyScapheDataConverter
//
//  Created by 堀 昌樹 on 11/11/27.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "BSDCAppDelegate.h"

#import "BSCoreDataManager.h"
#import "DatabaseManager.h"


@implementation BSDCAppDelegate

@synthesize window = _window;
@synthesize cdManager;

- (void)dealloc
{
    [super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	// Insert code here to initialize your application
	self.cdManager = [BSCoreDataManager defaultManager];
	[DatabaseManager defaultManager];
}


+ (NSURL *)bathyScapheSupportFolderURL
{
	return [NSURL fileURLWithPath:[self bathyScapheSupportFolderPath]];
}
+ (NSString *)bathyScapheSupportFolderPath
{
	static NSString *bathyscapheSupportFolderPath = nil;
	
	if(bathyscapheSupportFolderPath) return bathyscapheSupportFolderPath;
	
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSApplicationSupportDirectory,
														 NSUserDomainMask,
														 YES);
	if(!paths || [paths count] == 0) {
		NSLog(@"Could not find Application Support folder");
		exit(-1);
	}
	
	NSString *supportFolder = [paths objectAtIndex:0];
	if([supportFolder length] == 0) {
		NSLog(@"Could not find Application SUpport folder");
		exit(-2);
	}
	
	bathyscapheSupportFolderPath = [supportFolder stringByAppendingPathComponent:@"BathyScaphe"];
	[bathyscapheSupportFolderPath retain];
	
	return bathyscapheSupportFolderPath;
}

@end
