# -*- mode: perl; coding: utf-8 -*-
# Keitairc::Log::Syslog
#
# Copyright (c) 2010 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2

package Keitairc::Log::Syslog;

use Sys::Syslog qw(:standard :macros);
use Keitairc::Config;
use strict;
use warnings;

sub new {
	my ($proto, $arg) = @_;
	my $cf = $arg->{config};

	my $me = {};

	my ($type, $facility) = split(':', $cf->log(), 2);
	$facility ||= 'local0';

	openlog('keitairc', 'cons,pid', $facility);
	if ($cf->debug()) {
		setlogmask(LOG_UPTO(LOG_DEBUG));
	} else {
		setlogmask(LOG_UPTO(LOG_INFO));
	}
	bless $me;
}

sub log_access {
	my ($me, $m) = @_;
	syslog(LOG_NOTICE, $m);
}

sub log_info {
	my ($me, $m) = @_;
	syslog(LOG_INFO, $m);
}

sub log_error {
	my ($me, $m) = @_;
	syslog(LOG_ERR, $m);
}

sub log_debug {
	my ($me, $m) = @_;
	syslog(LOG_DEBUG, $m);
}

sub log_close {
	closelog();
}

1;
