/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * !! Do not include this file directly !!
 *
 * Include camera_metadata.h instead.
 */

/**
 * Top level hierarchy definitions for camera metadata. *_INFO sections are for
 * the static metadata that can be retrived without opening the camera device.
 * New sections must be added right before ANDROID_SECTION_COUNT to maintain
 * existing enumerations.
 */
enum {
    ANDROID_REQUEST = 0,
    ANDROID_LENS,
    ANDROID_LENS_INFO,
    ANDROID_SENSOR,
    ANDROID_SENSOR_INFO,
    ANDROID_FLASH,
    ANDROID_FLASH_INFO,
    ANDROID_HOT_PIXEL,
    ANDROID_HOT_PIXEL_INFO,
    ANDROID_DEMOSAIC,
    ANDROID_DEMOSAIC_INFO,
    ANDROID_NOISE,
    ANDROID_NOISE_INFO,
    ANDROID_SHADING,
    ANDROID_SHADING_INFO,
    ANDROID_GEOMETRIC,
    ANDROID_GEOMETRIC_INFO,
    ANDROID_COLOR,
    ANDROID_COLOR_INFO,
    ANDROID_TONEMAP,
    ANDROID_TONEMAP_INFO,
    ANDROID_EDGE,
    ANDROID_EDGE_INFO,
    ANDROID_SCALER,
    ANDROID_SCALER_INFO,
    ANDROID_JPEG,
    ANDROID_JPEG_INFO,
    ANDROID_STATS,
    ANDROID_STATS_INFO,
    ANDROID_CONTROL,
    ANDROID_CONTROL_INFO,
    ANDROID_SECTION_COUNT,

    VENDOR_SECTION = 0x8000
};

/**
 * Hierarchy positions in enum space. All vendor extension tags must be
 * defined with tag >= VENDOR_SECTION_START
 */
enum {
    ANDROID_REQUEST_START         = ANDROID_REQUEST        << 16,
    ANDROID_LENS_START            = ANDROID_LENS           << 16,
    ANDROID_LENS_INFO_START       = ANDROID_LENS_INFO      << 16,
    ANDROID_SENSOR_START          = ANDROID_SENSOR         << 16,
    ANDROID_SENSOR_INFO_START     = ANDROID_SENSOR_INFO    << 16,
    ANDROID_FLASH_START           = ANDROID_FLASH          << 16,
    ANDROID_FLASH_INFO_START      = ANDROID_FLASH_INFO     << 16,
    ANDROID_HOT_PIXEL_START       = ANDROID_HOT_PIXEL      << 16,
    ANDROID_HOT_PIXEL_INFO_START  = ANDROID_HOT_PIXEL_INFO << 16,
    ANDROID_DEMOSAIC_START        = ANDROID_DEMOSAIC       << 16,
    ANDROID_DEMOSAIC_INFO_START   = ANDROID_DEMOSAIC_INFO  << 16,
    ANDROID_NOISE_START           = ANDROID_NOISE          << 16,
    ANDROID_NOISE_INFO_START      = ANDROID_NOISE_INFO     << 16,
    ANDROID_SHADING_START         = ANDROID_SHADING        << 16,
    ANDROID_SHADING_INFO_START    = ANDROID_SHADING_INFO   << 16,
    ANDROID_GEOMETRIC_START       = ANDROID_GEOMETRIC      << 16,
    ANDROID_GEOMETRIC_INFO_START  = ANDROID_GEOMETRIC_INFO << 16,
    ANDROID_COLOR_START           = ANDROID_COLOR          << 16,
    ANDROID_COLOR_INFO_START      = ANDROID_COLOR_INFO     << 16,
    ANDROID_TONEMAP_START         = ANDROID_TONEMAP        << 16,
    ANDROID_TONEMAP_INFO_START    = ANDROID_TONEMAP_INFO   << 16,
    ANDROID_EDGE_START            = ANDROID_EDGE           << 16,
    ANDROID_EDGE_INFO_START       = ANDROID_EDGE_INFO      << 16,
    ANDROID_SCALER_START          = ANDROID_SCALER         << 16,
    ANDROID_SCALER_INFO_START     = ANDROID_SCALER_INFO    << 16,
    ANDROID_JPEG_START            = ANDROID_JPEG           << 16,
    ANDROID_JPEG_INFO_START       = ANDROID_JPEG_INFO      << 16,
    ANDROID_STATS_START           = ANDROID_STATS          << 16,
    ANDROID_STATS_INFO_START      = ANDROID_STATS_INFO     << 16,
    ANDROID_CONTROL_START         = ANDROID_CONTROL        << 16,
    ANDROID_CONTROL_INFO_START    = ANDROID_CONTROL_INFO   << 16,
    VENDOR_SECTION_START          = VENDOR_SECTION         << 16
};

/**
 * Main enum for defining camera metadata tags.  New entries must always go
 * before the section _END tag to preserve existing enumeration values.  In
 * addition, the name and type of the tag needs to be added to
 * system/media/camera/src/camera_metadata_tag_info.c
 */
enum {
    ANDROID_REQUEST_ID = ANDROID_REQUEST_START,
    ANDROID_REQUEST_METADATA_MODE,
    ANDROID_REQUEST_OUTPUT_STREAMS,
    ANDROID_REQUEST_FRAME_COUNT,
    ANDROID_REQUEST_END,

    ANDROID_LENS_FOCUS_DISTANCE = ANDROID_LENS_START,
    ANDROID_LENS_APERTURE,
    ANDROID_LENS_FOCAL_LENGTH,
    ANDROID_LENS_FILTER_DENSITY,
    ANDROID_LENS_OPTICAL_STABILIZATION_MODE,
    ANDROID_LENS_FOCUS_RANGE,
    ANDROID_LENS_END,

    ANDROID_LENS_MINIMUM_FOCUS_DISTANCE = ANDROID_LENS_INFO_START,
    ANDROID_LENS_AVAILABLE_FOCAL_LENGTHS,
    ANDROID_LENS_AVAILABLE_APERTURES,
    ANDROID_LENS_AVAILABLE_FILTER_DENSITY,
    ANDROID_LENS_AVAILABLE_OPTICAL_STABILIZATION,
    ANDROID_LENS_SHADING_MAP,
    ANDROID_LENS_GEOMETRIC_CORRECTION_MAP,
    ANDROID_LENS_FACING,
    ANDROID_LENS_POSITION,
    ANDROID_LENS_INFO_END,

    ANDROID_SENSOR_EXPOSURE_TIME = ANDROID_SENSOR_START,
    ANDROID_SENSOR_FRAME_DURATION,
    ANDROID_SENSOR_SENSITIVITY,
    ANDROID_SENSOR_TIMESTAMP,
    ANDROID_SENSOR_END,

    ANDROID_SENSOR_EXPOSURE_TIME_RANGE = ANDROID_SENSOR_INFO_START,
    ANDROID_SENSOR_MAX_FRAME_DURATION,
    ANDROID_SENSOR_AVAILABLE_SENSITIVITIES,
    ANDROID_SENSOR_COLOR_FILTER_ARRANGEMENT,
    ANDROID_SENSOR_PIXEL_ARRAY_SIZE,
    ANDROID_SENSOR_ACTIVE_ARRAY_SIZE,
    ANDROID_SENSOR_WHITE_LEVEL,
    ANDROID_SENSOR_BLACK_LEVEL_PATTERN,
    ANDROID_SENSOR_COLOR_TRANSFORM_1,
    ANDROID_SENSOR_COLOR_TRANSFORM_2,
    ANDROID_SENSOR_REFERENCE_ILLUMINANT_1,
    ANDROID_SENSOR_REFERENCE_ILLUMINANT_2,
    ANDROID_SENSOR_FORWARD_MATRIX_1,
    ANDROID_SENSOR_FORWARD_MATRIX_2,
    ANDROID_SENSOR_CALIBRATION_TRANSFORM_1,
    ANDROID_SENSOR_CALIBRATION_TRANSFORM_2,
    ANDROID_SENSOR_BASE_GAIN_FACTOR,
    ANDROID_SENSOR_MAX_ANALOG_SENSITIVITY,
    ANDROID_SENSOR_NOISE_MODEL_COEFFICIENTS,
    ANDROID_SENSOR_ORIENTATION,
    ANDROID_SENSOR_INFO_END,

    ANDROID_FLASH_MODE = ANDROID_FLASH_START,
    ANDROID_FLASH_FIRING_POWER,
    ANDROID_FLASH_FIRING_TIME,
    ANDROID_FLASH_END,

    ANDROID_FLASH_AVAILABLE_MODES = ANDROID_FLASH_INFO_START,
    ANDROID_FLASH_CHARGE_DURATION,
    ANDROID_FLASH_INFO_END,

    ANDROID_HOT_PIXEL_MODE = ANDROID_HOT_PIXEL_START,
    ANDROID_HOT_PIXEL_END,

    ANDROID_HOT_PIXEL_INFO_END = ANDROID_HOT_PIXEL_INFO_START,

    ANDROID_DEMOSAIC_MODE = ANDROID_DEMOSAIC_START,
    ANDROID_DEMOSAIC_END,

    ANDROID_DEMOSAIC_INFO_END = ANDROID_DEMOSAIC_INFO_START,

    ANDROID_NOISE_MODE = ANDROID_NOISE_START,
    ANDROID_NOISE_STRENGTH,
    ANDROID_NOISE_END,

    ANDROID_NOISE_INFO_END = ANDROID_NOISE_INFO_START,

    ANDROID_SHADING_MODE  = ANDROID_SHADING_START,
    ANDROID_SHADING_END,

    ANDROID_SHADING_INFO_END = ANDROID_SHADING_INFO_START,

    ANDROID_GEOMETRIC_MODE  = ANDROID_GEOMETRIC_START,
    ANDROID_GEOMETRIC_END,

    ANDROID_GEOMETRIC_INFO_END = ANDROID_GEOMETRIC_INFO_START,

    ANDROID_COLOR_MODE = ANDROID_COLOR_START,
    ANDROID_COLOR_TRANSFORM,
    ANDROID_COLOR_END,

    ANDROID_COLOR_AVAILABLE_MODES = ANDROID_COLOR_INFO_START,
    ANDROID_COLOR_INFO_END,

    ANDROID_TONEMAP_MODE = ANDROID_TONEMAP_START,
    ANDROID_TONEMAP_CURVE_RED,
    ANDROID_TONEMAP_CURVE_GREEN,
    ANDROID_TONEMAP_CURVE_BLUE,
    ANDROID_TONEMAP_END,

    ANDROID_TONEMAP_MAX_CURVE_POINTS = ANDROID_TONEMAP_INFO_START,
    ANDROID_TONEMAP_INFO_END,

    ANDROID_EDGE_MODE = ANDROID_EDGE_START,
    ANDROID_EDGE_STRENGTH,
    ANDROID_EDGE_END,

    ANDROID_EDGE_INFO_END = ANDROID_EDGE_INFO_START,

    ANDROID_SCALER_SIZE = ANDROID_SCALER_START,
    ANDROID_SCALER_FORMAT,
    ANDROID_SCALER_CROP_REGION,
    ANDROID_SCALER_ROTATION,
    ANDROID_SCALER_END,

    ANDROID_SCALER_AVAILABLE_FORMATS = ANDROID_SCALER_INFO_START,
    ANDROID_SCALER_AVAILABLE_SIZES_PER_FORMAT,
    ANDROID_SCALER_AVAILABLE_SIZES,
    ANDROID_SCALER_AVAILABLE_MIN_FRAME_DURATIONS,
    ANDROID_SCALER_AVAILABLE_MAX_ZOOM,
    ANDROID_SCALER_INFO_END,

    ANDROID_JPEG_QUALITY = ANDROID_JPEG_START,
    ANDROID_JPEG_THUMBNAIL_SIZE,
    ANDROID_JPEG_THUMBNAIL_QUALITY,
    ANDROID_JPEG_GPS_COORDINATES,
    ANDROID_JPEG_GPS_PROCESSING_METHOD,
    ANDROID_JPEG_GPS_TIMESTAMP,
    ANDROID_JPEG_ORIENTATION,
    ANDROID_JPEG_END,

    ANDROID_JPEG_AVAILABLE_THUMBNAIL_SIZES  = ANDROID_JPEG_INFO_START,
    ANDROID_JPEG_INFO_END,

    ANDROID_STATS_FACE_DETECT_MODE = ANDROID_STATS_START,
    ANDROID_STATS_HISTOGRAM_MODE,
    ANDROID_STATS_SHARPNESS_MAP_MODE,
    ANDROID_STATS_FACE_RECTANGLES,
    ANDROID_STATS_FACE_SCORES,
    ANDROID_STATS_FACE_LANDMARKS,
    ANDROID_STATS_FACE_IDS,
    ANDROID_STATS_HISTOGRAM,
    ANDROID_STATS_SHARPNESS_MAP,
    ANDROID_STATS_END,

    ANDROID_STATS_AVAILABLE_FACE_DETECT_MODES = ANDROID_STATS_INFO_START,
    ANDROID_STATS_MAX_FACE_COUNT,
    ANDROID_STATS_HISTOGRAM_BUCKET_COUNT,
    ANDROID_STATS_MAX_HISTOGRAM_COUNT,
    ANDROID_STATS_SHARPNESS_MAP_SIZE,
    ANDROID_STATS_MAX_SHARPNESS_MAP_VALUE,
    ANDROID_STATS_INFO_END,

    ANDROID_CONTROL_MODE = ANDROID_CONTROL_START,
    ANDROID_CONTROL_AE_MODE,
    ANDROID_CONTROL_AE_REGIONS,
    ANDROID_CONTROL_AE_EXP_COMPENSATION,
    ANDROID_CONTROL_AE_TARGET_FPS_RANGE,
    ANDROID_CONTROL_AE_ANTIBANDING_MODE,
    ANDROID_CONTROL_AWB_MODE,
    ANDROID_CONTROL_AWB_REGIONS,
    ANDROID_CONTROL_AF_MODE,
    ANDROID_CONTROL_AF_REGIONS,
    ANDROID_CONTROL_AF_TRIGGER,
    ANDROID_CONTROL_AF_STATE,
    ANDROID_CONTROL_VIDEO_STABILIZATION_MODE,
    ANDROID_CONTROL_END,

    ANDROID_CONTROL_AVAILABLE_MODES = ANDROID_CONTROL_INFO_START,
    ANDROID_CONTROL_MAX_REGIONS,
    ANDROID_CONTROL_AE_AVAILABLE_MODES,
    ANDROID_CONTROL_AE_EXP_COMPENSATION_STEP,
    ANDROID_CONTROL_AE_EXP_COMPENSATION_RANGE,
    ANDROID_CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES,
    ANDROID_CONTROL_AE_AVAILABLE_ANTIBANDING_MODES,
    ANDROID_CONTROL_AWB_AVAILABLE_MODES,
    ANDROID_CONTROL_AF_AVAILABLE_MODES,
    ANDROID_CONTROL_INFO_END
};

/**
 * Enumeration definitions for the various entries that need them
 */

// ANDROID_REQUEST_METADATA_MODE
enum {
    ANDROID_REQUEST_METADATA_NONE = 0,
    ANDROID_REQUEST_METADATA_FULL
};

// ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT
enum {
    ANDROID_SENSOR_RGGB = 0,
    ANDROID_SENSOR_GRBG,
    ANDROID_SENSOR_GBRG,
    ANDROID_SENSOR_BGGR,
    ANDROID_SENSOR_RGB
};

// ANDROID_SCALER_AVAILABLE_FORMATS uses HAL_PIXEL_FORMAT_* from
// system/graphics.h
