<?php
class UnregistCardController extends AppController {
	var $uses = array('User', 'Course');
	var $helpers = array('Javascript', 'Html');

	function index() {

		$users = $this->User->userlist(true);
		$users = array_unique($users);

		$this->set('users', $users);

		if (count($users) >= 1) {

			App::import('Core', 'HttpSocket');
			$socket = new HttpSocket();

			App::import('Helper', 'Html');
			$html = new HtmlHelper();
			
			$url = 'http://localhost' . $html->url('get');
			$query = array('name' => $users[0]);

			$result = $socket->get($url, $query);
			foreach( explode('&', $result) as $values ) {
				list($key, $value) = explode('=', $values);
				$this->set($key, $value);
			}
		}
	}

	function get() {
		$this->autoRender = false;
		$args = '';

		$user = $_GET['name'];
		$query = array('conditions' => array('name' => $user));
		$results = $this->User->find('first', $query);
		if ($results != false) {
			$result = $results['User'];

			if (isset($result['course'])) {
				$result['course'] = $this->Course->name($result['course']);
			}

			$splitter = '';
			foreach ( $result as $key => $value) {
				$args .= "$splitter" . htmlspecialchars($key)
				      .'=' . htmlspecialchars($value);
				$splitter = '&';
			}
			return $args;
		} else {
			//var_dump($_GET);
		}
	}

	function del() {
		$this->autoRender = false;
		$args = '';

		$user = $_GET['name'];
		$query = array('conditions' => array('name' => $user));
		$results = $this->User->find('first', $query);
		if ($results != false) {
			$result = $results['User'];
			$result['use'] = 0;
			$this->User->save($result);
		} else {
			//var_dump($_GET);
		}
	}
}
?>

