<?php
// 指定日表示
class DailyController extends AppController {
	var $uses = array('User', 'Data', 'Course');

	function index() {

		$date = '';
		if (isset($_POST['dates'])) {
			$date = h($_POST['dates']);
		} else {
			$date = date('Y-m-d');
		}

		// 日付指定メニュー作成
		$this->set('datemenu', $this->_datemenu(14, $date));

		// 対象日のデータ取得
                $query = array('conditions' => array( 'date(create_t)' => "$date" ),
                                'order' => array('create_t'));
                $datas = $this->Data->find('all', $query);

		// コース取得
		$query = array();
		$courses = $this->Course->find('all', $query);
		$course = $courses;
		//var_dump($course);

		// 集計
		$daily = array();
		foreach ( $datas as $data ) {
			$vdata = $data['Data'];
			$name = $vdata['name'];
			$create = $vdata['create_t'];
			if (array_key_exists("$name", $daily)) {
				if (array_key_exists('end_t', $daily["$name"])) {
					unset($daily["$name"]['end_t']);
				}
				$daily["$name"] += array('end_t' => $create);
			} else {
				$daily["$name"] = array('begin_t' => $create);
			}
		}

		$color = "white";

		// 表示
		$table = '<table class="sheet">';
		$table .= '<thead><tr>'.PHP_EOL;
		$table .= '<th class="name">なまえ</td>';
		$table .= '<th class="time">入室</td>';
		$table .= '<th class="time">退室</td>';
		$table .= '</tr></thead>';
		$table .= '<tbody>'.PHP_EOL;
		foreach( $daily as $key => $value ) {
			$table .= '<tr><td class="name" style="background-color:'.$color.';">'. $key . '</td>';
			$table .= '<td class="time">'. $this->_Hi($value, 'begin_t') . '</td>';
			$table .= '<td class="time">'. $this->_Hi($value, 'end_t') . '</td></tr>'.PHP_EOL;
		}
		$table .= '</tbody>';
		$table .= '</table>';
		$this->set('dailytable', $table);
	}

	public function save() {
		;
	}
}
?>

