﻿Public Class frmProgress

    Friend Property downloder As downloder

    Private Sub BackgroundWorker1_DoWork(sender As System.Object, e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        Try
            downloder.Start()
        Catch ex As CancelException
            e.Cancel = True
        End Try
    End Sub

    Private Sub frmProgress_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        BackgroundWorker1.RunWorkerAsync()
    End Sub

    Private Sub BackgroundWorker1_ProgressChanged(sender As System.Object, e As System.ComponentModel.ProgressChangedEventArgs) Handles BackgroundWorker1.ProgressChanged
        lblKifuFileName.Text = String.Format("{0}", e.UserState)
        If downloder.IsDownloading Then
            Me.Text = String.Format("棋譜ダウンロード中（{0}/{1})",
                                    downloder.DownLoadIndex,
                                    downloder.DownLoadsCount)
            pbProgress.Maximum = downloder.DownLoadsCount
            pbProgress.Value = downloder.DownLoadIndex
        End If
        If downloder.IsComplete Then
            btnOk.Visible = True
            btnCancel.Visible = False
        End If
    End Sub

    Private Sub btnOk_Click(sender As System.Object, e As System.EventArgs) Handles btnOk.Click
        Me.Close()
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        BackgroundWorker1.CancelAsync()
        Me.Close()
    End Sub
End Class