﻿using System;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.IO;

namespace whois
{
    public partial class Form1 : Form
    {
        private TcpClient tcpC;
        private String domain = "";
        private String whoisServer = "";
        private NetworkStream netStream;

        delegate void appendTextDelegate(string text);
        private void appendText(string text)
        {
            if (this.IsDisposed) return;
            Invoke(new appendTextDelegate(rtbox_show.AppendText), text);
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_search_Click(object sender, EventArgs e)
        {
            domain = tbox_source.Text.Trim();
            if (domain == String.Empty)
            {
                MessageBox.Show("検索したいドメインを入力してください。");
                return;
            }
            domain += "\r\n";
            whoisServer = tbox_server.Text.Trim();
            if (whoisServer == String.Empty)
            {
                MessageBox.Show("whoisサーバが指定されていません。");
                return;
            }
            Thread tMain = new Thread(new ThreadStart(search));
            tMain.IsBackground = true;
            tMain.Start();
        }
        private void search()
        {
            try
            {
                String server = Dns.GetHostByName(whoisServer).AddressList[0].ToString();
                tcpC = new TcpClient(server, 43);
            }catch(Exception ee)
            {
                MessageBox.Show("サーバに接続できません。" + "\r\n" + ee.Message);
                return;
            }
            netStream = tcpC.GetStream();
            byte[] bb = new byte[64];
            String msg = null;
            bb = System.Text.Encoding.ASCII.GetBytes(domain.ToCharArray());
            netStream.Write(bb, 0, bb.Length);

            StreamReader sr = new StreamReader(netStream, System.Text.Encoding.UTF8);
            while((msg = sr.ReadLine()) != null)
            {
                appendText(msg + "\r\n");
            }
            appendText("finished!");
            tcpC.Close();
        }
    }
}
