﻿using System;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Text;

namespace Server
{
    public partial class Form1 : Form
    {
        private Socket sock;
        private static ManualResetEvent socketEvent = new System.Threading.ManualResetEvent(false);
        private Thread tMain;

        delegate void appendTextDelegate(string text);
        private void appendText(string text)
        {
            if (this.IsDisposed) return;
            Invoke(new appendTextDelegate(rtbox_show.AppendText), text);
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_start_Click(object sender, EventArgs e)
        {
            if (tbox_port.Text == String.Empty)
            {
                MessageBox.Show("portを指定してください。");
                return;
            }
            int port;
            if (Int32.TryParse(tbox_port.Text, out port) == false)
            {
                MessageBox.Show("portは0～65535の数字を入力してください。");
                return;
            }
            if (port < 0 || 65535 < port)
            {
                MessageBox.Show("portは0～65535の範囲で入力してください。");
                return;
            }
            String hostName = Dns.GetHostName();
            IPHostEntry iPHostEntry = Dns.GetHostEntry(hostName);
            IPAddress ipAddress = iPHostEntry.AddressList[4];//todo:IPv4のアドレスを選ぶように
            sock = new Socket(
                AddressFamily.InterNetwork,
                SocketType.Stream,
                ProtocolType.Tcp);
            try
            {
                sock.Bind(new IPEndPoint(ipAddress, port));
                sock.Listen(10);
                appendText("サーバ起動中...\r\n");
                appendText(String.Format("サーバIPアドレス:{0}\r\n",ipAddress));
                appendText(String.Format("ポート:{0}\r\n",port));
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
            tMain = new Thread(new ThreadStart(Round));
            tMain.IsBackground = true;
            tMain.Start();
        }

        private void Round()
        {
            while(true)
            {
                socketEvent.Reset();
                sock.BeginAccept(new AsyncCallback(OnConnectRequest), sock);
                socketEvent.WaitOne();
            }
        }

        private void OnConnectRequest(IAsyncResult ar)
        {
            socketEvent.Set();
            Socket listener = (Socket)ar.AsyncState;
            Socket handler = listener.EndAccept(ar);
            appendText(String.Format("{0} joined \r\n", handler.RemoteEndPoint));
            StateObject state = new StateObject();
            state.workSocket = handler;
            handler.BeginReceive(state.buffer, 0, StateObject.BufferSize, 0,
                new AsyncCallback(ReadCallback), state);
        }

        private void ReadCallback(IAsyncResult ar)
        {
            String content = String.Empty;
            StateObject state = (StateObject)ar.AsyncState;
            Socket handler = state.workSocket;
            int readSize = handler.EndReceive(ar);
            if(readSize < 1)
            {
                appendText(String.Format("\r\n{0} disconnected \r\n", handler.RemoteEndPoint));
                return;
            }
            byte[] bb = new byte[readSize];
            Array.Copy(state.buffer, bb, readSize);
            String msg = Encoding.UTF8.GetString(bb);
            appendText(msg);
            handler.BeginReceive(state.buffer, 0, StateObject.BufferSize, 0,
                new AsyncCallback(ReadCallback), state);
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            try
            {
                sock.Close();
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}
