﻿using System;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace Client
{
    public partial class Form1 : Form
    {
        private Socket Sock;
        private ManualResetEvent connectDone = new ManualResetEvent(false);
        private ManualResetEvent sendDone = new ManualResetEvent(false);

        delegate void stateTextSetDelegate(string text);
        private void stateTextSet(string text)
        {
            if (this.IsDisposed) return;
            Invoke(new stateTextSetDelegate(tbox_stateTextSet), text);
        }
        private void tbox_stateTextSet(string text)
        {
            tbox_stat.Text = text;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_start_Click(object sender, EventArgs e)
        {
            if (tbox_ip.Text.Trim() == String.Empty)
            {
                MessageBox.Show("ipを指定してください。");
                return;
            }
            if (tbox_port.Text == String.Empty)
            {
                MessageBox.Show("portを指定してください。");
                return;
            }
            int port;
            if (Int32.TryParse(tbox_port.Text, out port) == false)
            {
                MessageBox.Show("portは0～65535の数字を入力してください。");
                return;
            }
            if (port < 0 || 65535 < port)
            {
                MessageBox.Show("portは0～65535の範囲で入力してください。");
                return;
            }

            IPAddress ipAddress = IPAddress.Parse(tbox_ip.Text.Trim());
            IPEndPoint serverEP = new IPEndPoint(ipAddress, port);
            Sock = new Socket(AddressFamily.InterNetwork,
                SocketType.Stream,
                ProtocolType.Tcp);
            try
            {
                Sock.BeginConnect(serverEP,
                    new AsyncCallback(ConnectCallback),
                    Sock);
                connectDone.WaitOne();
                byte[] bb = System.Text.Encoding.UTF8.GetBytes("Client >> Hello \r\n");
                Sock.BeginSend(bb, 0, bb.Length, 0, new AsyncCallback(SendCallback), Sock);
                sendDone.WaitOne();
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
        private void ConnectCallback(IAsyncResult ar)
        {
            Socket client = (Socket)ar.AsyncState;
            client.EndConnect(ar);
            stateTextSet(String.Format("{0}に接続しています", client.RemoteEndPoint));
            connectDone.Set();
        }
        private void SendCallback(IAsyncResult ar)
        {
            Socket client = (Socket)ar.AsyncState;
            int sentSize = client.EndSend(ar);
            sendDone.Set();
        }

        private void btn_msg_Click(object sender, EventArgs e)
        {
            byte[] bb = System.Text.Encoding.UTF8.GetBytes("Client >>> " + rtbox_msg.Text + "\r\n");
            try
            {
                Sock.BeginSend(bb, 0, bb.Length, 0, new AsyncCallback(SendCallback), Sock);
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            try
            {
                Sock.Close();
                stateTextSet("接続していません");
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}
