﻿using System;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace Server
{
    public partial class Form1 : Form
    {
        private IPAddress myIP = IPAddress.Parse("127.0.0.1");
        private IPEndPoint ipEP;
        private Socket sock;
        private Socket newSock;
        private Thread tMain;

        delegate void appendTextDelegate(string text);
        private void appendText(string text)
        {
            if (this.IsDisposed) return;
            Invoke(new appendTextDelegate(rtbox_show.AppendText), text);
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_start_Click(object sender, EventArgs e)
        {
            if (tbox_port.Text == String.Empty)
            {
                MessageBox.Show("portを指定してください。");
                return;
            }
            int port;
            if (Int32.TryParse(tbox_port.Text,out port) == false)
            {
                MessageBox.Show("portは0～65535の数字を入力してください。");
                return;
            }
            if (port < 0 || 65535 < port)
            {
                MessageBox.Show("portは0～65535の範囲で入力してください。");
                return;
            }
            try
            {
                ipEP = new IPEndPoint(myIP, port);
                sock = new Socket(AddressFamily.InterNetwork,
                    SocketType.Stream,
                    ProtocolType.Tcp);
                sock.Bind(ipEP);
                sock.Listen(10);
                appendText("サーバ起動中...\r\n");
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
                return;
            }
            tMain = new Thread(new ThreadStart(waitConn));
            tMain.IsBackground = true;
            tMain.Start();
        }

        private void waitConn()
        {
            while(true)
            {
                newSock = sock.Accept();
                if (newSock.Connected)
                {
                    appendText("クライアントからの接続があります。...\r\n");
                    while (true)
                    {
                        byte[] rec = new byte[1024];
                        newSock.Receive(rec);
                        string msg = System.Text.Encoding.UTF8.GetString(rec);
                        appendText(msg + "\r\n");
                    }
                }
            }
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            try
            {
                newSock.Close();
                tMain.Abort();
                sock.Close();
                appendText("\r\nサーバ停止中\r\n");
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}
