﻿using System;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;


namespace Client
{
    public partial class Form1 : Form
    {
        private Socket sock;
        private IPAddress server;
        private IPEndPoint ipEP;

        public Form1()
        {
            InitializeComponent();
        }

        private void btn_start_Click(object sender, System.EventArgs e)
        {
            if (tbox_ip.Text.Trim() == String.Empty)
            {
                MessageBox.Show("ipを指定してください。");
                return;
            }
            if (tbox_port.Text == String.Empty)
            {
                MessageBox.Show("portを指定してください。");
                return;
            }
            int port;
            if (Int32.TryParse(tbox_port.Text, out port) == false)
            {
                MessageBox.Show("portは0～65535の数字を入力してください。");
                return;
            }
            if (port < 0 || 65535 < port)
            {
                MessageBox.Show("portは0～65535の範囲で入力してください。");
                return;
            }

            server = IPAddress.Parse(tbox_ip.Text.Trim());
            ipEP = new IPEndPoint(server, port);
            sock = new Socket(
                AddressFamily.InterNetwork,
                SocketType.Stream,
                ProtocolType.Tcp);
            try
            {
                sock.Connect(ipEP);
                tbox_stat.Text = "サーバに接続しています!";
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            try
            {
                sock.Close();
                tbox_stat.Text = "接続を切ります!";
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        private void btn_msg_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] bb;//= new byte[1024];
                string msg = "Client >>> " + rtbox_msg.Text + "\r\n";
                bb = System.Text.Encoding.UTF8.GetBytes(msg.ToCharArray());
                sock.Send(bb);
            }catch(Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}
