<?php

// Start of xmlwriter v.0.1

class XMLWriter  {

	/**
	 * ソース URI を指定して新しい xmlwriter を作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-open-uri.php
	 * @param uri string <p>
	 * 出力するリソースの URI。
	 * </p>
	 * @return bool オブジェクト指向型: 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * </p>
	 * <p>
	 * 手続き型: 成功した場合に、その後の xmlwriter
	 * 関数で使用するための新しい xmlwriter リソース、
	 * エラーの場合に FALSE を返します。
	 */
	public function openUri ($uri) {}

	/**
	 * 文字列の出力にメモリを使用する新しい xmlwriter を作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-open-memory.php
	 * @return bool オブジェクト指向型: 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * </p>
	 * <p>
	 * 手続き型: 成功した場合に、その後の xmlwriter
	 * 関数で使用するための新しい xmlwriter リソース、
	 * エラーの場合に FALSE を返します。
	 */
	public function openMemory () {}

	/**
	 * 字下げの on/off を切り替える
	 * @link http://www.php.net/manual/ja/function.xmlwriter-set-indent.php
	 * @param indent bool <p>
	 * 字下げを有効にするかどうか。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setIndent ($indent) {}

	/**
	 * 字下げに使用する文字列を設定する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-set-indent-string.php
	 * @param indentString string <p>
	 * 字下げ用の文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setIndentString ($indentString) {}

	/**
	 * コメントを開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-comment.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startComment () {}

	/**
	 * コメントの終了部を作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-comment.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endComment () {}

	/**
	 * 属性を開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-attribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startAttribute ($name) {}

	/**
	 * 属性を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-attribute.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endAttribute () {}

	/**
	 * 属性全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-attribute.php
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @param value string <p>
	 * 属性の値。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeAttribute ($name, $value) {}

	/**
	 * 名前空間つきの属性を開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-attribute-ns.php
	 * @param prefix string <p>
	 * 名前空間プレフィックス。
	 * </p>
	 * @param name string <p>
	 * 属性の名前。
	 * </p>
	 * @param uri string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startAttributeNs ($prefix, $name, $uri) {}

	/**
	 * 名前空間つき属性全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-attribute-ns.php
	 * @param prefix string <p>
	 * 名前空間プレフィックス。
	 * </p>
	 * @param name string <p>
	 * 属性名。
	 * </p>
	 * @param uri string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param content string <p>
	 * 属性の値。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeAttributeNs ($prefix, $name, $uri, $content) {}

	/**
	 * 要素の開始タグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-element.php
	 * @param name string <p>
	 * 要素名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startElement ($name) {}

	/**
	 * 現在の要素を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-element.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endElement () {}

	/**
	 * 現在の要素を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-full-end-element.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function fullEndElement () {}

	/**
	 * 名前空間つき要素の開始タグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-element-ns.php
	 * @param prefix string <p>
	 * 名前空間プレフィックス。
	 * </p>
	 * @param name string <p>
	 * 要素名。
	 * </p>
	 * @param uri string <p>
	 * 名前空間 URI。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startElementNs ($prefix, $name, $uri) {}

	/**
	 * 要素タグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-element.php
	 * @param name string <p>
	 * 要素名。
	 * </p>
	 * @param content string[optional] <p>
	 * 要素の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeElement ($name, $content = null) {}

	/**
	 * 名前空間つき要素タグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-element-ns.php
	 * @param prefix string <p>
	 * 名前空間プレフィックス。
	 * </p>
	 * @param name string <p>
	 * 要素名。
	 * </p>
	 * @param uri string <p>
	 * 名前空間 URI。
	 * </p>
	 * @param content string[optional] <p>
	 * 要素の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeElementNs ($prefix, $name, $uri, $content = null) {}

	/**
	 * PI (処理命令) の開始タグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-pi.php
	 * @param target string <p>
	 * 処理命令の対象。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startPi ($target) {}

	/**
	 * 現在の PI (処理命令) を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-pi.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endPi () {}

	/**
	 * PI (処理命令) 書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-pi.php
	 * @param target string <p>
	 * 処理命令の対象。
	 * </p>
	 * @param content string <p>
	 * 処理命令の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writePi ($target, $content) {}

	/**
	 * CDATA の開始タグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-cdata.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startCdata () {}

	/**
	 * 現在の CDATA を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-cdata.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endCdata () {}

	/**
	 * CDATA タグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-cdata.php
	 * @param content string <p>
	 * CDATA の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeCdata ($content) {}

	/**
	 * テキストを書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-text.php
	 * @param content string <p>
	 * テキストの内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function text ($content) {}

	/**
	 * 生の XML テキストを書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-raw.php
	 * @param content string <p>
	 * 書き込むテキスト文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeRaw ($content) {}

	/**
	 * ドキュメントタグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-document.php
	 * @param version string[optional] <p>
	 * XML 宣言で使用するドキュメントのバージョン番号。
	 * </p>
	 * @param encoding string[optional] <p>
	 * XML 宣言で使用するドキュメントのエンコーディング。
	 * </p>
	 * @param standalone string[optional] <p>
	 * yes あるいは no。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startDocument ($version = null, $encoding = null, $standalone = null) {}

	/**
	 * 現在のドキュメントを終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-document.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endDocument () {}

	/**
	 * コメントタグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-comment.php
	 * @param content string <p>
	 * コメントの内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeComment ($content) {}

	/**
	 * DTD の開始タグを作成する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-dtd.php
	 * @param qualifiedName string <p>
	 * 作成するドキュメント型の修飾名。
	 * </p>
	 * @param publicId string[optional] <p>
	 * 外部サブセットの公開識別子。
	 * </p>
	 * @param systemId string[optional] <p>
	 * 外部サブセットのシステム識別子。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startDtd ($qualifiedName, $publicId = null, $systemId = null) {}

	/**
	 * 現在の DTD を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-dtd.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endDtd () {}

	/**
	 * DTD タグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-dtd.php
	 * @param name string <p>
	 * DTD 名。
	 * </p>
	 * @param publicId string[optional] <p>
	 * 外部サブセットの公開識別子。
	 * </p>
	 * @param systemId string[optional] <p>
	 * 外部サブセットのシステム識別子。
	 * </p>
	 * @param subset string[optional] <p>
	 * DTD の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeDtd ($name, $publicId = null, $systemId = null, $subset = null) {}

	/**
	 * DTD 要素を開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-dtd-element.php
	 * @param qualifiedName string <p>
	 * 作成するドキュメント型の修飾名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startDtdElement ($qualifiedName) {}

	/**
	 * 現在の DTD 要素を終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-dtd-element.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endDtdElement () {}

	/**
	 * DTD 要素タグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-dtd-element.php
	 * @param name string <p>
	 * DTD 要素の名前。
	 * </p>
	 * @param content string <p>
	 * 要素の内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeDtdElement ($name, $content) {}

	/**
	 * DTD 属性リストを開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-dtd-attlist.php
	 * @param name string <p>
	 * 属性リストの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startDtdAttlist ($name) {}

	/**
	 * 現在の DTD 属性リストを終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-dtd-attlist.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endDtdAttlist () {}

	/**
	 * DTD 属性リストタグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-dtd-attlist.php
	 * @param name string <p>
	 * DTD 属性リストの名前。
	 * </p>
	 * @param content string <p>
	 * DTD 属性リストの内容。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeDtdAttlist ($name, $content) {}

	/**
	 * DTD エンティティを開始する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-start-dtd-entity.php
	 * @param name string <p>
	 * エンティティの名前。
	 * </p>
	 * @param isparam bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function startDtdEntity ($name, $isparam) {}

	/**
	 * 現在の DTD エンティティを終了する
	 * @link http://www.php.net/manual/ja/function.xmlwriter-end-dtd-entity.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function endDtdEntity () {}

	/**
	 * DTD エンティティタグ全体を書き込む
	 * @link http://www.php.net/manual/ja/function.xmlwriter-write-dtd-entity.php
	 * @param name string <p>
	 * エンティティの名前。
	 * </p>
	 * @param content string <p>
	 * エンティティの内容。
	 * </p>
	 * @param pe bool 
	 * @param pubid string 
	 * @param sysid string 
	 * @param ndataid string 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writeDtdEntity ($name, $content, $pe, $pubid, $sysid, $ndataid) {}

	/**
	 * 現在のバッファを返す
	 * @link http://www.php.net/manual/ja/function.xmlwriter-output-memory.php
	 * @param flush bool[optional] <p>
	 * 出力バッファをフラッシュするかどうか。デフォルトは TRUE。
	 * </p>
	 * @return string 現在のバッファを文字列で返します。
	 */
	public function outputMemory ($flush = null) {}

	/**
	 * 現在のバッファをフラッシュする
	 * @link http://www.php.net/manual/ja/function.xmlwriter-flush.php
	 * @param empty bool[optional] <p>
	 * バッファを空にするかどうか。デフォルトは TRUE です。
	 * </p>
	 * @return mixed ライターをメモリにオープンした場合は、この関数は出来上がった XML バッファを返します。
	 * そうではなく URI を使用している場合は、この関数はバッファを書き込み、
	 * 書き込んだバイト数を返します。
	 */
	public function flush ($empty = null) {}

}

/**
 * @param uri
 */
function xmlwriter_open_uri ($uri) {}

function xmlwriter_open_memory () {}

/**
 * @param xmlwriter
 * @param indent
 */
function xmlwriter_set_indent ($xmlwriter, $indent) {}

/**
 * @param xmlwriter
 * @param indentString
 */
function xmlwriter_set_indent_string ($xmlwriter, $indentString) {}

/**
 * @param xmlwriter
 */
function xmlwriter_start_comment ($xmlwriter) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_comment ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 */
function xmlwriter_start_attribute ($xmlwriter, $name) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_attribute ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 * @param value
 */
function xmlwriter_write_attribute ($xmlwriter, $name, $value) {}

/**
 * @param xmlwriter
 * @param prefix
 * @param name
 * @param uri
 */
function xmlwriter_start_attribute_ns ($xmlwriter, $prefix, $name, $uri) {}

/**
 * @param xmlwriter
 * @param prefix
 * @param name
 * @param uri
 * @param content
 */
function xmlwriter_write_attribute_ns ($xmlwriter, $prefix, $name, $uri, $content) {}

/**
 * @param xmlwriter
 * @param name
 */
function xmlwriter_start_element ($xmlwriter, $name) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_element ($xmlwriter) {}

/**
 * @param xmlwriter
 */
function xmlwriter_full_end_element ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param prefix
 * @param name
 * @param uri
 */
function xmlwriter_start_element_ns ($xmlwriter, $prefix, $name, $uri) {}

/**
 * @param xmlwriter
 * @param name
 * @param content[optional]
 */
function xmlwriter_write_element ($xmlwriter, $name, $content) {}

/**
 * @param xmlwriter
 * @param prefix
 * @param name
 * @param uri
 * @param content[optional]
 */
function xmlwriter_write_element_ns ($xmlwriter, $prefix, $name, $uri, $content) {}

/**
 * @param xmlwriter
 * @param target
 */
function xmlwriter_start_pi ($xmlwriter, $target) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_pi ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param target
 * @param content
 */
function xmlwriter_write_pi ($xmlwriter, $target, $content) {}

/**
 * @param xmlwriter
 */
function xmlwriter_start_cdata ($xmlwriter) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_cdata ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param content
 */
function xmlwriter_write_cdata ($xmlwriter, $content) {}

/**
 * @param xmlwriter
 * @param content
 */
function xmlwriter_text ($xmlwriter, $content) {}

/**
 * @param xmlwriter
 * @param content
 */
function xmlwriter_write_raw ($xmlwriter, $content) {}

/**
 * @param xmlwriter
 * @param version[optional]
 * @param encoding[optional]
 * @param standalone[optional]
 */
function xmlwriter_start_document ($xmlwriter, $version, $encoding, $standalone) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_document ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param content
 */
function xmlwriter_write_comment ($xmlwriter, $content) {}

/**
 * @param xmlwriter
 * @param qualifiedName
 * @param publicId[optional]
 * @param systemId[optional]
 */
function xmlwriter_start_dtd ($xmlwriter, $qualifiedName, $publicId, $systemId) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_dtd ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 * @param publicId[optional]
 * @param systemId[optional]
 * @param subset[optional]
 */
function xmlwriter_write_dtd ($xmlwriter, $name, $publicId, $systemId, $subset) {}

/**
 * @param xmlwriter
 * @param qualifiedName
 */
function xmlwriter_start_dtd_element ($xmlwriter, $qualifiedName) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_dtd_element ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 * @param content
 */
function xmlwriter_write_dtd_element ($xmlwriter, $name, $content) {}

/**
 * @param xmlwriter
 * @param name
 */
function xmlwriter_start_dtd_attlist ($xmlwriter, $name) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_dtd_attlist ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 * @param content
 */
function xmlwriter_write_dtd_attlist ($xmlwriter, $name, $content) {}

/**
 * @param xmlwriter
 * @param name
 * @param isparam
 */
function xmlwriter_start_dtd_entity ($xmlwriter, $name, $isparam) {}

/**
 * @param xmlwriter
 */
function xmlwriter_end_dtd_entity ($xmlwriter) {}

/**
 * @param xmlwriter
 * @param name
 * @param content
 */
function xmlwriter_write_dtd_entity ($xmlwriter, $name, $content) {}

/**
 * @param xmlwriter
 * @param flush[optional]
 */
function xmlwriter_output_memory ($xmlwriter, $flush) {}

/**
 * @param xmlwriter
 * @param empty[optional]
 */
function xmlwriter_flush ($xmlwriter, $empty) {}

// End of xmlwriter v.0.1
?>
