<?php

// Start of snmp v.0.1

class SNMP  {
	const VERSION_1 = 0;
	const VERSION_2c = 1;
	const VERSION_2C = 1;
	const VERSION_3 = 3;
	const ERRNO_NOERROR = 0;
	const ERRNO_ANY = 126;
	const ERRNO_GENERIC = 2;
	const ERRNO_TIMEOUT = 4;
	const ERRNO_ERROR_IN_REPLY = 8;
	const ERRNO_OID_NOT_INCREASING = 16;
	const ERRNO_OID_PARSING_ERROR = 32;
	const ERRNO_MULTIPLE_SET_QUERIES = 64;


	/**
	 * リモート <acronym>SNMP</acronym> エージェントへのセッションを表す SNMP インスタンスを作成する
	 * @link http://www.php.net/manual/ja/snmp.construct.php
	 * @param version
	 * @param host
	 * @param community
	 * @param timeout[optional]
	 * @param retries[optional]
	 */
	public function __construct ($version, $host, $community, $timeout, $retries) {}

	/**
	 * <acronym>SNMP</acronym> セッションを閉じる
	 * @link http://www.php.net/manual/ja/snmp.close.php
	 */
	public function close () {}

	/**
	 * セキュリティ関連の <acronym>SNMP</acronym>v3 セッションパラメータを設定する
	 * @link http://www.php.net/manual/ja/snmp.setsecurity.php
	 * @param session
	 * @param sec_level
	 * @param auth_protocol
	 * @param auth_passphrase
	 * @param priv_protocol
	 * @param priv_passphrase
	 * @param contextName
	 * @param contextEngineID
	 * @param var1[optional]
	 */
	public function setSecurity ($session, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $contextName, $contextEngineID, $var9) {}

	/**
	 * <acronym>SNMP</acronym> オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/snmp.get.php
	 * @param object_id
	 * @param use_orignames[optional]
	 */
	public function get ($object_id, $use_orignames) {}

	/**
	 * 指定したオブジェクト ID に続く <acronym>SNMP</acronym> オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/snmp.getnext.php
	 * @param object_id
	 * @param use_orignames[optional]
	 */
	public function getnext ($object_id, $use_orignames) {}

	/**
	 * <acronym>SNMP</acronym> オブジェクトのサブツリーを取得する
	 * @link http://www.php.net/manual/ja/snmp.walk.php
	 * @param object_id
	 * @param suffix_keys
	 * @param max_repetitions
	 * @param non_repeaters
	 */
	public function walk ($object_id, $suffix_keys, $max_repetitions, $non_repeaters) {}

	/**
	 * <acronym>SNMP</acronym> オブジェクトの値を設定する
	 * @link http://www.php.net/manual/ja/snmp.set.php
	 * @param object_id
	 * @param type
	 * @param value
	 */
	public function set ($object_id, $type, $value) {}

	/**
	 * 直近のエラーコードを取得する
	 * @link http://www.php.net/manual/ja/snmp.geterrno.php
	 */
	public function getErrno () {}

	/**
	 * 直近のエラーメッセージを取得する
	 * @link http://www.php.net/manual/ja/snmp.geterror.php
	 */
	public function getError () {}

}

class SNMPException extends RuntimeException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

/**
 * <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmpget.php
 * @param hostname string <p>
 * SNMP エージェント。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト。
 * </p>
 * @param timeout int[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries int[optional] <p>
 * タイムアウトが発生したときの再試行の回数。
 * </p>
 * @return string 成功した場合に SNMP オブジェクトの値、失敗した場合に FALSE を返します。
 */
function snmpget ($hostname, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したオブジェクト ID に続く <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmpgetnext.php
 * @param host string <p>SNMP エージェント (サーバー) のホスト名。</p>
 * @param community string <p>リードコミュニティ。</p>
 * @param object_id string <p>前にある SNMP オブジェクトの ID。</p>
 * @param timeout int[optional] <p>最初のタイムアウトまでのマイクロ秒数。</p>
 * @param retries int[optional] <p>タイムアウト発生時の再試行回数。</p>
 * @return string 成功した場合に SNMP オブジェクトの値、エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmpgetnext ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * エージェントから全ての <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmpwalk.php
 * @param hostname string <p>
 * SNMP エージェント (サーバー)。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * NULL の場合は、object_id
 * が SNMP オブジェクトツリーのルートとして解釈され、
 * ツリーの配下のすべてのオブジェクトを配列として返します。
 * </p>
 * <p>
 * object_id を指定した場合は、
 * その object_id の配下のすべての
 * SNMP オブジェクトを返します。
 * </p>
 * @param timeout int[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries int[optional] <p>タイムアウト発生時の再試行回数。</p>
 * @return array object_id からの
 * SNMP オブジェクトの値の配列をルートとして返します。
 * エラーの場合に FALSE を返します。
 */
function snmpwalk ($hostname, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したオブジェクトに関するオブジェクト ID
   を含むすべてのオブジェクトを返す
 * @link http://www.php.net/manual/ja/function.snmprealwalk.php
 * @param host string <p>SNMP エージェント (サーバー) のホスト名。</p>
 * @param community string <p>リードコミュニティ。</p>
 * @param object_id string <p>前にある SNMP オブジェクト ID。</p>
 * @param timeout int[optional] <p>最初のタイムアウトまでのマイクロ秒数。</p>
 * @param retries int[optional] <p>タイムアウト発生時の再試行回数。</p>
 * @return array 成功した場合に SNMP オブジェクト ID とその値の連想配列。エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmprealwalk ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * ネットワークエンティティに関する情報ツリーを検索する
 * @link http://www.php.net/manual/ja/function.snmpwalkoid.php
 * @param hostname string <p>
 * SNMP エージェント。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * NULL の場合は、object_id
 * が SNMP オブジェクトツリーのルートとして解釈され、
 * ツリーの配下のすべてのオブジェクトを配列として返します。
 * </p>
 * <p>
 * object_id を指定した場合は、
 * その object_id の配下のすべての
 * SNMP オブジェクトを返します。
 * </p>
 * @param timeout int[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries int[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return array object_id からの
 * SNMP オブジェクトの値の配列をルートとして返します。
 * エラーの場合に FALSE を返します。
 */
function snmpwalkoid ($hostname, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * <acronym>SNMP</acronym> オブジェクトの値を設定する
 * @link http://www.php.net/manual/ja/function.snmpset.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param community string <p>
 * ライトコミュニティ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param type string The MIB defines the type of each object id. It has to be specified as a single character from the below list.
 * </p>
 * types
 * <tr valign="top"><td>=</td><td>The type is taken from the MIB</td></tr>
 * <tr valign="top"><td>i</td><td>INTEGER</td> </tr>
 * <tr valign="top"><td>u</td><td>INTEGER</td></tr>
 * <tr valign="top"><td>s</td><td>STRING</td></tr>
 * <tr valign="top"><td>x</td><td>HEX STRING</td></tr>
 * <tr valign="top"><td>d</td><td>DECIMAL STRING</td></tr>
 * <tr valign="top"><td>n</td><td>NULLOBJ</td></tr>
 * <tr valign="top"><td>o</td><td>OBJID</td></tr>
 * <tr valign="top"><td>t</td><td>TIMETICKS</td></tr>
 * <tr valign="top"><td>a</td><td>IPADDRESS</td></tr>
 * <tr valign="top"><td>b</td><td>BITS</td></tr>
 * </table>
 * If OPAQUE_SPECIAL_TYPES was defined while compiling the SNMP library, the following are also valid:
 * </p>
 * types
 * <tr valign="top"><td>U</td><td>unsigned int64</td></tr>
 * <tr valign="top"><td>I</td><td>signed int64</td></tr>
 * <tr valign="top"><td>F</td><td>float</td></tr>
 * <tr valign="top"><td>D</td><td>double</td></tr>
 * </table>
 * これらの大半は、対応する ASN.1 の型を使います。&apos;s&apos;, &apos;x&apos;, &apos;d&apos; および &apos;b&apos; はどれも OCTET STRING
 * を異なる方法で表したものであり、&apos;u&apos; も Gauge32 値を扱うためのものです。
 * </p>
 * MIB ファイルが "snmp_read_mib" や libsnmp の設定で MIB ツリーに読み込まれている場合は、
 * type に &apos;=&apos; を使うことができます。
 * これはすべてのオブジェクト ID を表し、型は自動的に MIB から読み込みます。
 * </p>
 * "SYNTAX BITS {telnet(0), ftp(1), http(2), icmp(3), snmp(4), ssh(5), https(6)}"
 * のような BITS 型の値変数を設定する方法は二通りあることに注意しましょう。
 * </p>
 * 型として "b" を使い、ビット番号の一覧を指定する。この方法はおすすめしません。
 * 同じ OID に対して GET クエリを実行しても 0xF8 などを返すからです。
 * @param value mixed <p>
 * 新しい値。
 * </p>
 * @param timeout int[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries int[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * SNMP ホストがデータ型を却下すると、"Warning: Error in packet. 
 * Reason: (badValue) The value given has the wrong type or length." のような’
 * E_WARNING メッセージが表示されます。未知の OID あるいは無効な OID
 * を指定した場合は、おそらく "Could not add variable" のような警告となります。
 */
function snmpset ($host, $community, $object_id, $type, $value, $timeout = null, $retries = null) {}

/**
 * UCD ライブラリの quick_print の現在の設定値を取得する
 * @link http://www.php.net/manual/ja/function.snmp-get-quick-print.php
 * @param d
 * @return bool quick_print がオンの場合に TRUE、それ以外の場合に FALSE を返します。
 */
function snmp_get_quick_print ($d) {}

/**
 * UCB <acronym>SNMP</acronym> ライブラリで <parameter>quick_print</parameter> の値を設定する
 * @link http://www.php.net/manual/ja/function.snmp-set-quick-print.php
 * @param quick_print bool <p>
 * </p>
 * @return bool 値を返しません。
 */
function snmp_set_quick_print ($quick_print) {}

/**
 * すべての enum を、実際の整数値ではなく enum 値とともに返す
 * @link http://www.php.net/manual/ja/function.snmp-set-enum-print.php
 * @param enum_print int <p>
 * この値は boolean として Net-SNMP ライブラリが解釈します。"0" あるいは "1" しか指定できません。
 * </p>
 * @return bool 
 */
function snmp_set_enum_print ($enum_print) {}

/**
 * OID の出力形式を設定する
 * @link http://www.php.net/manual/ja/function.snmp-set-oid-output-format.php
 * @param oid_format int <table>
 * oid_format の値による OID .1.3.6.1.2.1.1.3.0 の表しかた
 * <tr valign="top"><td>SNMP_OID_OUTPUT_FULL</td><td>.iso.org.dod.internet.mgmt.mib-2.system.sysUpTime.sysUpTimeInstance</td></tr>
 * <tr valign="top"><td>SNMP_OID_OUTPUT_NUMERIC</td><td>.1.3.6.1.2.1.1.3.0</td> </tr>
 * </table>
 * <p>PHP 5.4.0 からはさらに 4 つの定数が使えるようになりました。
 * <table>
 * <tr valign="top"><td>SNMP_OID_OUTPUT_MODULE</td><td>DISMAN-EVENT-MIB::sysUpTimeInstance</td></tr>
 * <tr valign="top"><td>SNMP_OID_OUTPUT_SUFFIX</td><td>sysUpTimeInstance</td></tr>
 * <tr valign="top"><td>SNMP_OID_OUTPUT_UCD</td><td>system.sysUpTime.sysUpTimeInstance</td></tr>
 * <tr valign="top"><td>SNMP_OID_OUTPUT_NONE</td><td>Undefined</td></tr>
 * </table> 
 * </p>
 * @return bool 値を返しません。
 */
function snmp_set_oid_output_format ($oid_format) {}

/**
 * 指定したオブジェクト内の全てのオブジェクトを、対応するオブジェクト ID
   を含めて返す
 * @link http://www.php.net/manual/ja/function.snmp-set-oid-numeric-print.php
 * @param oid_format int 
 * @return void 
 */
function snmp_set_oid_numeric_print ($oid_format) {}

/**
 * <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmp2-get.php
 * @param host string <p>
 * SNMP エージェント。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return string 成功した場合に SNMP オブジェクトの値、エラー時に FALSE を返します。
 */
function snmp2_get ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したオブジェクト ID に続く <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmp2-getnext.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * 前にある SNMP オブジェクトの ID。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return string 成功した場合に SNMP オブジェクトの値、エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmp2_getnext ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * すべての <acronym>SNMP</acronym> オブジェクトをエージェントから取得する
 * @link http://www.php.net/manual/ja/function.snmp2-walk.php
 * @param host string <p>
 * SNMP エージェント (サーバー)。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * NULL の場合は object_id は
 * SNMP オブジェクトツリーのルートとなり、
 * ツリー配下のすべてのオブジェクトを配列で返します。
 * </p>
 * <p>
 * object_id を指定すると、
 * その object_id 以下のすべての
 * SNMP オブジェクトを返します。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return array object_id をルートとするすべての
 * SNMP オブジェクトの値の配列、あるいはエラー時に
 * FALSE を返します。
 */
function snmp2_walk ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したすべてのオブジェクトとそのオブジェクト ID を返す
 * @link http://www.php.net/manual/ja/function.snmp2-real-walk.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param community string <p>
 * リードコミュニティ。
 * </p>
 * @param object_id string <p>
 * 前にある SNMP オブジェクト ID。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return array 成功した場合に SNMP オブジェクト ID とその値の連想配列。エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmp2_real_walk ($host, $community, $object_id, $timeout = null, $retries = null) {}

/**
 * <acronym>SNMP</acronym> オブジェクトの値を設定する
 * @link http://www.php.net/manual/ja/function.snmp2-set.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param community string <p>
 * ライトコミュニティ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param type string The MIB defines the type of each object id. It has to be specified as a single character from the below list.
 * </p>
 * types
 * <tr valign="top"><td>=</td><td>The type is taken from the MIB</td></tr>
 * <tr valign="top"><td>i</td><td>INTEGER</td> </tr>
 * <tr valign="top"><td>u</td><td>INTEGER</td></tr>
 * <tr valign="top"><td>s</td><td>STRING</td></tr>
 * <tr valign="top"><td>x</td><td>HEX STRING</td></tr>
 * <tr valign="top"><td>d</td><td>DECIMAL STRING</td></tr>
 * <tr valign="top"><td>n</td><td>NULLOBJ</td></tr>
 * <tr valign="top"><td>o</td><td>OBJID</td></tr>
 * <tr valign="top"><td>t</td><td>TIMETICKS</td></tr>
 * <tr valign="top"><td>a</td><td>IPADDRESS</td></tr>
 * <tr valign="top"><td>b</td><td>BITS</td></tr>
 * </table>
 * If OPAQUE_SPECIAL_TYPES was defined while compiling the SNMP library, the following are also valid:
 * </p>
 * types
 * <tr valign="top"><td>U</td><td>unsigned int64</td></tr>
 * <tr valign="top"><td>I</td><td>signed int64</td></tr>
 * <tr valign="top"><td>F</td><td>float</td></tr>
 * <tr valign="top"><td>D</td><td>double</td></tr>
 * </table>
 * これらの大半は、対応する ASN.1 の型を使います。&apos;s&apos;, &apos;x&apos;, &apos;d&apos; および &apos;b&apos; はどれも OCTET STRING
 * を異なる方法で表したものであり、&apos;u&apos; も Gauge32 値を扱うためのものです。
 * </p>
 * MIB ファイルが "snmp_read_mib" や libsnmp の設定で MIB ツリーに読み込まれている場合は、
 * type に &apos;=&apos; を使うことができます。
 * これはすべてのオブジェクト ID を表し、型は自動的に MIB から読み込みます。
 * </p>
 * "SYNTAX BITS {telnet(0), ftp(1), http(2), icmp(3), snmp(4), ssh(5), https(6)}"
 * のような BITS 型の値変数を設定する方法は二通りあることに注意しましょう。
 * </p>
 * 型として "b" を使い、ビット番号の一覧を指定する。この方法はおすすめしません。
 * 同じ OID に対して GET クエリを実行しても 0xF8 などを返すからです。
 * @param value string <p>
 * 新しい値。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * SNMP ホストがデータ型を却下すると、"Warning: Error in packet. 
 * Reason: (badValue) The value given has the wrong type or length." のような’
 * E_WARNING メッセージが表示されます。未知の OID あるいは無効な OID
 * を指定した場合は、おそらく "Could not add variable" のような警告となります。
 */
function snmp2_set ($host, $community, $object_id, $type, $value, $timeout = null, $retries = null) {}

/**
 * <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmp3-get.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param sec_name string <p>
 * セキュリティ名。通常はユーザー名のようなもの。
 * </p>
 * @param sec_level string <p>
 * セキュリティレベル (noAuthNoPriv|authNoPriv|authPriv)。
 * </p>
 * @param auth_protocol string <p>
 * 認証プロトコル (MD5 あるいは SHA)。
 * </p>
 * @param auth_passphrase string <p>
 * 認証パスフレーズ。
 * </p>
 * @param priv_protocol string <p>
 * プライバシープロトコル (DES あるいは AES)。
 * </p>
 * @param priv_passphrase string <p>
 * プライバシーパスフレーズ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return string 成功した場合に SNMP オブジェクトの値、エラー時に FALSE を返します。
 */
function snmp3_get ($host, $sec_name, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したオブジェクト ID に続く <acronym>SNMP</acronym> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.snmp3-getnext.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param sec_name string <p>
 * セキュリティ名。通常はユーザー名のようなもの。
 * </p>
 * @param sec_level string <p>
 * セキュリティレベル (noAuthNoPriv|authNoPriv|authPriv)。
 * </p>
 * @param auth_protocol string <p>
 * 認証プロトコル (MD5 あるいは SHA)。
 * </p>
 * @param auth_passphrase string <p>
 * 認証パスフレーズ。
 * </p>
 * @param priv_protocol string <p>
 * プライバシープロトコル (DES あるいは AES)。
 * </p>
 * @param priv_passphrase string <p>
 * プライバシーパスフレーズ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return string 成功した場合に SNMP オブジェクトの値、エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmp3_getnext ($host, $sec_name, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $object_id, $timeout = null, $retries = null) {}

/**
 * すべての <acronym>SNMP</acronym> オブジェクトをエージェントから取得する
 * @link http://www.php.net/manual/ja/function.snmp3-walk.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param sec_name string <p>
 * セキュリティ名。通常はユーザー名のようなもの。
 * </p>
 * @param sec_level string <p>
 * セキュリティレベル (noAuthNoPriv|authNoPriv|authPriv)。
 * </p>
 * @param auth_protocol string <p>
 * 認証プロトコル (MD5 あるいは SHA)。
 * </p>
 * @param auth_passphrase string <p>
 * 認証パスフレーズ。
 * </p>
 * @param priv_protocol string <p>
 * プライバシープロトコル (DES あるいは AES)。
 * </p>
 * @param priv_passphrase string <p>
 * プライバシーパスフレーズ。
 * </p>
 * @param object_id string <p>
 * NULL の場合は object_id は
 * SNMP オブジェクトツリーのルートとなり、
 * ツリー配下のすべてのオブジェクトを配列で返します。
 * </p>
 * <p>
 * object_id を指定すると、
 * その object_id 以下のすべての
 * SNMP オブジェクトを返します。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return array object_id をルートとするすべての
 * SNMP オブジェクトの値の配列、あるいはエラー時に
 * FALSE を返します。
 */
function snmp3_walk ($host, $sec_name, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $object_id, $timeout = null, $retries = null) {}

/**
 * 指定したすべてのオブジェクトとそのオブジェクト ID を返す
 * @link http://www.php.net/manual/ja/function.snmp3-real-walk.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param sec_name string <p>
 * セキュリティ名。通常はユーザー名のようなもの。
 * </p>
 * @param sec_level string <p>
 * セキュリティレベル (noAuthNoPriv|authNoPriv|authPriv)。
 * </p>
 * @param auth_protocol string <p>
 * 認証プロトコル (MD5 あるいは SHA)。
 * </p>
 * @param auth_passphrase string <p>
 * 認証パスフレーズ。
 * </p>
 * @param priv_protocol string <p>
 * プライバシープロトコル (DES あるいは AES)。
 * </p>
 * @param priv_passphrase string <p>
 * プライバシーパスフレーズ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param timeout string[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries string[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return array 成功した場合に SNMP オブジェクト ID とその値の連想配列。エラー時に FALSE を返します。
 * エラー時には E_WARNING が発生します。
 */
function snmp3_real_walk ($host, $sec_name, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $object_id, $timeout = null, $retries = null) {}

/**
 * SNMP オブジェクトの値を設定する
 * @link http://www.php.net/manual/ja/function.snmp3-set.php
 * @param host string <p>
 * SNMP エージェント (サーバー) のホスト名。
 * </p>
 * @param sec_name string <p>
 * セキュリティ名。通常はユーザー名のようなもの。
 * </p>
 * @param sec_level string <p>
 * セキュリティレベル (noAuthNoPriv|authNoPriv|authPriv)。
 * </p>
 * @param auth_protocol string <p>
 * 認証プロトコル (MD5 あるいは SHA)。
 * </p>
 * @param auth_passphrase string <p>
 * 認証パスフレーズ。
 * </p>
 * @param priv_protocol string <p>
 * プライバシープロトコル (DES あるいは AES)。
 * </p>
 * @param priv_passphrase string <p>
 * プライバシーパスフレーズ。
 * </p>
 * @param object_id string <p>
 * SNMP オブジェクト ID。
 * </p>
 * @param type string The MIB defines the type of each object id. It has to be specified as a single character from the below list.
 * </p>
 * types
 * <tr valign="top"><td>=</td><td>The type is taken from the MIB</td></tr>
 * <tr valign="top"><td>i</td><td>INTEGER</td> </tr>
 * <tr valign="top"><td>u</td><td>INTEGER</td></tr>
 * <tr valign="top"><td>s</td><td>STRING</td></tr>
 * <tr valign="top"><td>x</td><td>HEX STRING</td></tr>
 * <tr valign="top"><td>d</td><td>DECIMAL STRING</td></tr>
 * <tr valign="top"><td>n</td><td>NULLOBJ</td></tr>
 * <tr valign="top"><td>o</td><td>OBJID</td></tr>
 * <tr valign="top"><td>t</td><td>TIMETICKS</td></tr>
 * <tr valign="top"><td>a</td><td>IPADDRESS</td></tr>
 * <tr valign="top"><td>b</td><td>BITS</td></tr>
 * </table>
 * If OPAQUE_SPECIAL_TYPES was defined while compiling the SNMP library, the following are also valid:
 * </p>
 * types
 * <tr valign="top"><td>U</td><td>unsigned int64</td></tr>
 * <tr valign="top"><td>I</td><td>signed int64</td></tr>
 * <tr valign="top"><td>F</td><td>float</td></tr>
 * <tr valign="top"><td>D</td><td>double</td></tr>
 * </table>
 * これらの大半は、対応する ASN.1 の型を使います。&apos;s&apos;, &apos;x&apos;, &apos;d&apos; および &apos;b&apos; はどれも OCTET STRING
 * を異なる方法で表したものであり、&apos;u&apos; も Gauge32 値を扱うためのものです。
 * </p>
 * MIB ファイルが "snmp_read_mib" や libsnmp の設定で MIB ツリーに読み込まれている場合は、
 * type に &apos;=&apos; を使うことができます。
 * これはすべてのオブジェクト ID を表し、型は自動的に MIB から読み込みます。
 * </p>
 * "SYNTAX BITS {telnet(0), ftp(1), http(2), icmp(3), snmp(4), ssh(5), https(6)}"
 * のような BITS 型の値変数を設定する方法は二通りあることに注意しましょう。
 * </p>
 * 型として "b" を使い、ビット番号の一覧を指定する。この方法はおすすめしません。
 * 同じ OID に対して GET クエリを実行しても 0xF8 などを返すからです。
 * @param value string <p>
 * 新しい値。
 * </p>
 * @param timeout int[optional] <p>
 * 最初のタイムアウトまでのマイクロ秒数。
 * </p>
 * @param retries int[optional] <p>
 * タイムアウト発生時の再試行回数。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * SNMP ホストがデータ型を却下すると、"Warning: Error in packet. 
 * Reason: (badValue) The value given has the wrong type or length." のような’
 * E_WARNING メッセージが表示されます。未知の OID あるいは無効な OID
 * を指定した場合は、おそらく "Could not add variable" のような警告となります。
 */
function snmp3_set ($host, $sec_name, $sec_level, $auth_protocol, $auth_passphrase, $priv_protocol, $priv_passphrase, $object_id, $type, $value, $timeout = null, $retries = null) {}

/**
 * SNMP の値が返される方法を設定する
 * @link http://www.php.net/manual/ja/function.snmp-set-valueretrieval.php
 * @param method int <table>
 * 型
 * <tr valign="top">
 * <td>SNMP_VALUE_LIBRARY</td>
 * <td>Net-SNMP ライブラリの返す形式のままで返します。</td>
 * </tr>
 * <tr valign="top">
 * <td>SNMP_VALUE_PLAIN</td>
 * <td>SNMP の型ヒントを含まないプレーンな値を返します。</td>
 * </tr>
 * <tr valign="top">
 * <td>SNMP_VALUE_OBJECT</td>
 * <td>
 * プロパティ "value" および "type" をもつオブジェクトを返します。
 * "type" は SNMP_OCTET_STR や SNMP_COUNTER などの定数のいずれかとなります。
 * "value" を返す方法は、定数
 * SNMP_VALUE_LIBRARY、SNMP_VALUE_PLAIN
 * のどちらが設定されているかによって決まります。
 * </td>
 * </tr>
 * </table>
 * @return bool 
 */
function snmp_set_valueretrieval ($method) {}

/**
 * SNMP の値が返される方法を返す
 * @link http://www.php.net/manual/ja/function.snmp-get-valueretrieval.php
 * @return int OR でつないだ定数 ( SNMP_VALUE_LIBRARY あるいは
 * SNMP_VALUE_PLAIN)
 * に、場合によって SNMP_VALUE_OBJECT を組み合わせて返します。
 */
function snmp_get_valueretrieval () {}

/**
 * アクティブな MIB ツリーの中に MIB ファイルを読み込んでパースする
 * @link http://www.php.net/manual/ja/function.snmp-read-mib.php
 * @param filename string <p>MIB のファイル名。</p>
 * @return bool 
 */
function snmp_read_mib ($filename) {}


/**
 * 5.4.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_SUFFIX', 1);

/**
 * 5.4.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_MODULE', 2);

/**
 * 5.2.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_FULL', 3);

/**
 * 5.2.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_NUMERIC', 4);

/**
 * 5.4.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_UCD', 5);

/**
 * 5.4.0 以降
 * @link http://www.php.net/manual/ja/snmp.constants.php
 */
define ('SNMP_OID_OUTPUT_NONE', 6);
define ('SNMP_VALUE_LIBRARY', 0);
define ('SNMP_VALUE_PLAIN', 1);
define ('SNMP_VALUE_OBJECT', 2);
define ('SNMP_BIT_STR', 3);
define ('SNMP_OCTET_STR', 4);
define ('SNMP_OPAQUE', 68);
define ('SNMP_NULL', 5);
define ('SNMP_OBJECT_ID', 6);
define ('SNMP_IPADDRESS', 64);
define ('SNMP_COUNTER', 66);
define ('SNMP_UNSIGNED', 66);
define ('SNMP_TIMETICKS', 67);
define ('SNMP_UINTEGER', 71);
define ('SNMP_INTEGER', 2);
define ('SNMP_COUNTER64', 70);

// End of snmp v.0.1
?>
