<?php

// Start of bz2 v.

/**
 * bzip2 圧縮されたファイルをオープンする
 * @link http://www.php.net/manual/ja/function.bzopen.php
 * @param filename string <p>
 * オープンするファイル名
 * </p>
 * @param mode string <p>
 * fopen 関数と同様ですが、
 * 'r' (読み込み) と 'w' (書き込み) だけをサポートしています。
 * それ以外を指定すると bzopen は FALSE を返します。
 * </p>
 * @return resource オープンできなかった場合、bzopen は FALSE
 * を返します。それ以外の場合は、
 * 新規にオープンされたファイルへのポインタが返されます。
 */
function bzopen ($filename, $mode) {}

/**
 * バイナリ対応の bzip2 ファイル読み込み
 * @link http://www.php.net/manual/ja/function.bzread.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @param length int[optional] <p>
 * 指定されない場合、bzread
 * は一度に (圧縮前の状態で) 1024バイト読み込みます。
 * 最大で 8192 バイト (圧縮前) までを一度に読み込みます。
 * </p>
 * @return string 非圧縮データ、もしくはエラー時に FALSE を返します。
 */
function bzread ($bz, $length = null) {}

/**
 * バイナリ対応の bzip2 ファイルへの書き込み
 * @link http://www.php.net/manual/ja/function.bzwrite.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @param data string <p>
 * 書き込むデータ
 * </p>
 * @param length int[optional] <p>
 * 指定した場合、
 * (圧縮前の) length バイト分の書き込みが終ったか、
 * data の終端に達したかで書き込みは終了します。
 * </p>
 * @return int 書き込んだバイト数、もしくはエラー時に FALSE を返します。
 */
function bzwrite ($bz, $data, $length = null) {}

/**
 * 全てのバッファリングされたデータを強制的に書き込む
 * @link http://www.php.net/manual/ja/function.bzflush.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @return int 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function bzflush ($bz) {}

/**
 * bzip2 ファイルを閉じる
 * @link http://www.php.net/manual/ja/function.bzclose.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @return int 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function bzclose ($bz) {}

/**
 * bzip2 エラー番号を返す
 * @link http://www.php.net/manual/ja/function.bzerrno.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @return int 整数としてのエラー番号を返します。
 */
function bzerrno ($bz) {}

/**
 * bzip2 エラー文字列を返す
 * @link http://www.php.net/manual/ja/function.bzerrstr.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @return string エラーメッセージを含む文字列を返します。
 */
function bzerrstr ($bz) {}

/**
 * bzip2 エラー番号とエラー文字列を配列で返す
 * @link http://www.php.net/manual/ja/function.bzerror.php
 * @param bz resource <p>
 * ファイルポインタ。これは有効である必要があり、
 * bzopen によりオープンされたファイルを指してい
 * る必要があります。
 * </p>
 * @return array errno エントリにエラーコード、errstr
 * エントリにエラーメッセージを持つ連想配列を返します。
 */
function bzerror ($bz) {}

/**
 * 文字列をbzip2形式のデータに圧縮する
 * @link http://www.php.net/manual/ja/function.bzcompress.php
 * @param source string <p>
 * 圧縮する文字列
 * </p>
 * @param blocksize int[optional] <p>
 * 圧縮時のブロック長を指定します。
 * 1 から 9 の数とする必要があります。この場合、9
 * の圧縮度が最大ですが、リソースの消費量も最大となります。
 * </p>
 * @param workfactor int[optional] <p>
 * 繰り返しが多い、最悪の入力データの場合の圧縮処理の動作を制御します。
 * この値は、0 から 250 までとなり、0 は特別な場合です。
 * </p>
 * <p>
 * workfactor によらず、
 * 生成される出力は同じになります。
 * </p>
 * @return mixed 圧縮された文字列、もしくはエラー時はエラー数
 */
function bzcompress ($source, $blocksize = null, $workfactor = null) {}

/**
 * bzip2 形式のデータを解凍する
 * @link http://www.php.net/manual/ja/function.bzdecompress.php
 * @param source string <p>
 * 解凍する文字列
 * </p>
 * @param small int[optional] <p>
 * TRUE の場合、よりメモリの消
 * 費量が少ない (所要メモリは最大2300K程度まで少なくなります)
 * 別の圧縮アルゴリズムが使用されますが、速度は約半分になってしまいます。
 * </p>
 * <p>
 * この機能に関する詳細については、bzip2
 * ドキュメント を参照ください。
 * </p>
 * @return mixed 解凍された文字列列、もしくはエラー時はエラー数
 */
function bzdecompress ($source, $small = null) {}

// End of bz2 v.
?>
